/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.layout;

import de.lessvoid.nifty.layout.Box;
import de.lessvoid.nifty.layout.BoxConstraints;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.List;

public class LayoutPart {
    private final Box box;
    private final BoxConstraints boxConstraints;

    public LayoutPart() {
        this.box = new Box();
        this.boxConstraints = new BoxConstraints();
    }

    public LayoutPart(Box newBox, BoxConstraints newBoxConstraints) {
        this.box = newBox;
        this.boxConstraints = newBoxConstraints;
    }

    public LayoutPart(LayoutPart src) {
        this.box = new Box(src.getBox());
        this.boxConstraints = new BoxConstraints(src.getBoxConstraints());
    }

    public final Box getBox() {
        return this.box;
    }

    public final BoxConstraints getBoxConstraints() {
        return this.boxConstraints;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("box [" + this.box.getX() + ", " + this.box.getY() + ", " + this.box.getWidth() + ", " + this.box.getHeight() + "] with constraints [" + this.boxConstraints.getX() + ", " + this.boxConstraints.getY() + ", " + this.boxConstraints.getWidth() + ", " + this.boxConstraints.getHeight() + "]");
        return result.toString();
    }

    public SizeValue getMaxWidth(List<LayoutPart> children) {
        int newWidth = 0;
        for (LayoutPart e : children) {
            int partWidth = e.getBoxConstraints().getWidth().getValueAsInt(0.0f);
            partWidth += e.getBoxConstraints().getMarginLeft().getValueAsInt(0.0f);
            if ((partWidth += e.getBoxConstraints().getMarginRight().getValueAsInt(0.0f)) <= newWidth) continue;
            newWidth = partWidth;
        }
        return SizeValue.px(newWidth);
    }

    public SizeValue getMaxHeight(List<LayoutPart> children) {
        int newHeight = 0;
        for (LayoutPart e : children) {
            int partHeight = e.getBoxConstraints().getHeight().getValueAsInt(0.0f);
            partHeight += e.getBoxConstraints().getMarginTop().getValueAsInt(0.0f);
            if ((partHeight += e.getBoxConstraints().getMarginBottom().getValueAsInt(0.0f)) <= newHeight) continue;
            newHeight = partHeight;
        }
        return SizeValue.px(newHeight);
    }

    public SizeValue getSumWidth(List<LayoutPart> children) {
        int newWidth = 0;
        for (LayoutPart e : children) {
            newWidth += e.getBoxConstraints().getMarginLeft().getValueAsInt(0.0f);
            newWidth += e.getBoxConstraints().getWidth().getValueAsInt(0.0f);
            newWidth += e.getBoxConstraints().getMarginRight().getValueAsInt(0.0f);
        }
        return SizeValue.px(newWidth);
    }

    public SizeValue getSumHeight(List<LayoutPart> children) {
        int newHeight = 0;
        for (LayoutPart e : children) {
            newHeight += e.getBoxConstraints().getHeight().getValueAsInt(0.0f);
            newHeight += e.getBoxConstraints().getMarginTop().getValueAsInt(0.0f);
            newHeight += e.getBoxConstraints().getMarginBottom().getValueAsInt(0.0f);
        }
        return SizeValue.px(newHeight);
    }
}

