/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyMethodInvoker;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.ElementInteractionClickHandler;
import de.lessvoid.nifty.elements.ElementInteractionMoveHandler;
import de.lessvoid.nifty.elements.PrimaryClickMouseMethods;
import de.lessvoid.nifty.elements.SecondaryClickMouseMethods;
import de.lessvoid.nifty.elements.TertiaryClickMouseMethods;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;

public class ElementInteraction {
    private String onClickAlternateKey;
    private NiftyMethodInvoker onMouseOverMethod;
    private NiftyMethodInvoker onMouseWheelMethod;
    private ElementInteractionClickHandler primary;
    private ElementInteractionClickHandler secondary;
    private ElementInteractionClickHandler tertiary;
    private ElementInteractionMoveHandler move;

    public ElementInteraction(Nifty niftyParam, Element element) {
        this.primary = new ElementInteractionClickHandler(niftyParam, element, new PrimaryClickMouseMethods(element));
        this.secondary = new ElementInteractionClickHandler(niftyParam, element, new SecondaryClickMouseMethods(element));
        this.tertiary = new ElementInteractionClickHandler(niftyParam, element, new TertiaryClickMouseMethods(element));
        this.move = new ElementInteractionMoveHandler(niftyParam, element);
    }

    public void resetMouseDown() {
        this.primary.resetMouseDown();
        this.secondary.resetMouseDown();
        this.tertiary.resetMouseDown();
    }

    public ElementInteractionClickHandler getPrimary() {
        return this.primary;
    }

    public ElementInteractionClickHandler getSecondary() {
        return this.secondary;
    }

    public ElementInteractionClickHandler getTertiary() {
        return this.tertiary;
    }

    public void setOnMouseOver(NiftyMethodInvoker method) {
        this.onMouseOverMethod = method;
    }

    public void setOnMouseWheelMethod(NiftyMethodInvoker method) {
        this.onMouseWheelMethod = method;
    }

    public boolean onMouseOver(Element element, NiftyMouseInputEvent inputEvent) {
        if (this.onMouseOverMethod != null) {
            return this.onMouseOverMethod.invoke(element, inputEvent);
        }
        return false;
    }

    public boolean onMouseWheel(Element element, NiftyMouseInputEvent inputEvent) {
        if (this.onMouseWheelMethod != null) {
            return this.onMouseWheelMethod.invoke(element, inputEvent);
        }
        return false;
    }

    public void setAlternateKey(String newAlternateKey) {
        this.onClickAlternateKey = newAlternateKey;
    }

    public boolean process(NiftyMouseInputEvent mouseEvent, long eventTime, boolean mouseInside, boolean canHandleInteraction, boolean hasMouseAccess) {
        this.move.process(canHandleInteraction, mouseInside, hasMouseAccess, mouseEvent);
        return this.primary.process(mouseEvent, mouseEvent.isButton0Down(), mouseEvent.isButton0InitialDown(), mouseEvent.isButton0Release(), eventTime, mouseInside, canHandleInteraction, hasMouseAccess, this.onClickAlternateKey) || this.secondary.process(mouseEvent, mouseEvent.isButton1Down(), mouseEvent.isButton1InitialDown(), mouseEvent.isButton1Release(), eventTime, mouseInside, canHandleInteraction, hasMouseAccess, this.onClickAlternateKey) || this.tertiary.process(mouseEvent, mouseEvent.isButton2Down(), mouseEvent.isButton2InitialDown(), mouseEvent.isButton2Release(), eventTime, mouseInside, canHandleInteraction, hasMouseAccess, this.onClickAlternateKey);
    }

    public void activate(Nifty nifty) {
        this.primary.activate(nifty);
    }
}

