/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.Color;

public class TextColorAnimated
implements EffectImpl {
    private Color currentColor = new Color("#000f");
    private Color tempColor = new Color("#000f");
    private Color startColor;
    private Color endColor;

    @Override
    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.startColor = new Color(parameter.getProperty("startColor", "#0000"));
        this.endColor = new Color(parameter.getProperty("endColor", "#ffff"));
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        this.currentColor.linear(this.startColor, this.endColor, normalizedTime);
        if (falloff == null) {
            this.setColor(r, this.currentColor);
        } else {
            this.tempColor.mutiply(this.currentColor, falloff.getFalloffValue());
            this.setColor(r, this.tempColor);
        }
    }

    private void setColor(NiftyRenderEngine r, Color color) {
        if (r.isColorAlphaChanged()) {
            r.setColorIgnoreAlpha(color);
        } else {
            r.setColor(color);
        }
    }

    @Override
    public void deactivate() {
    }
}

