/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.util.ReflectionUtil;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.windows.WindowsGraphicsDevice;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.ProxySurface;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.RegisteredClassFactory;
import jogamp.opengl.DesktopGLDynamicLookupHelper;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.SharedResourceRunner;
import jogamp.opengl.windows.wgl.WGL;
import jogamp.opengl.windows.wgl.WindowsBitmapWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsDummyWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsExternalWGLContext;
import jogamp.opengl.windows.wgl.WindowsExternalWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsOnscreenWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsPbufferWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLDynamicLibraryBundleInfo;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;

public class WindowsWGLDrawableFactory
extends GLDrawableFactoryImpl {
    private static final DesktopGLDynamicLookupHelper windowsWGLDynamicLookupHelper;
    WindowsGraphicsDevice defaultDevice;
    SharedResourceImplementation sharedResourceImpl;
    SharedResourceRunner sharedResourceRunner;
    Thread sharedResourceThread;
    HashMap sharedMap = new HashMap();
    long processAffinityChanges = 0L;
    PointerBuffer procMask = PointerBuffer.allocateDirect((int)1);
    PointerBuffer sysMask = PointerBuffer.allocateDirect((int)1);
    static final String GL_ARB_pbuffer = "GL_ARB_pbuffer";
    static final String WGL_ARB_make_current_read = "WGL_ARB_make_current_read";
    static final String wglMakeContextCurrent = "wglMakeContextCurrent";
    private static final int GAMMA_RAMP_LENGTH = 256;

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper(int n) {
        return windowsWGLDynamicLookupHelper;
    }

    public WindowsWGLDrawableFactory() {
        new WindowsWGLGraphicsConfigurationFactory();
        if (GLProfile.isAWTAvailable()) {
            try {
                ReflectionUtil.createInstance((String)"jogamp.opengl.windows.wgl.awt.WindowsAWTWGLGraphicsConfigurationFactory", null, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (JogampRuntimeException jogampRuntimeException) {
                // empty catch block
            }
        }
        this.defaultDevice = new WindowsGraphicsDevice(0);
        this.sharedResourceImpl = new SharedResourceImplementation();
        this.sharedResourceRunner = new SharedResourceRunner(this.sharedResourceImpl);
        this.sharedResourceThread = new Thread((Runnable)this.sharedResourceRunner, Thread.currentThread().getName() + "-SharedResourceRunner");
        this.sharedResourceThread.setDaemon(true);
        this.sharedResourceThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void enterThreadCriticalZone() {
        PointerBuffer pointerBuffer = this.sysMask;
        synchronized (pointerBuffer) {
            long l;
            if (0L == this.processAffinityChanges && GDI.GetProcessAffinityMask((long)(l = GDI.GetCurrentProcess()), (PointerBuffer)this.procMask, (PointerBuffer)this.sysMask)) {
                if (DEBUG) {
                    System.err.println("WindowsWGLDrawableFactory.enterThreadCriticalZone() - 0x" + Long.toHexString(l) + " - " + Thread.currentThread().getName());
                    Thread.dumpStack();
                }
                this.processAffinityChanges = l;
                GDI.SetProcessAffinityMask((long)l, (long)1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void leaveThreadCriticalZone() {
        PointerBuffer pointerBuffer = this.sysMask;
        synchronized (pointerBuffer) {
            if (0L != this.processAffinityChanges) {
                long l = GDI.GetCurrentProcess();
                if (l != this.processAffinityChanges) {
                    throw new GLException("PID doesn't match: set PID 0x" + Long.toHexString(this.processAffinityChanges) + " this PID 0x" + Long.toHexString(l));
                }
                if (DEBUG) {
                    System.err.println("WindowsWGLDrawableFactory.leaveThreadCriticalZone() - 0x" + Long.toHexString(l) + " - " + Thread.currentThread().getName());
                }
                GDI.SetProcessAffinityMask((long)l, (long)this.sysMask.get(0));
            }
        }
    }

    @Override
    public final AbstractGraphicsDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    @Override
    public final boolean getIsDeviceCompatible(AbstractGraphicsDevice abstractGraphicsDevice) {
        return abstractGraphicsDevice instanceof WindowsGraphicsDevice;
    }

    protected final GLContext getSharedContextImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.sharedResourceRunner.getShared(abstractGraphicsDevice);
        if (null != resource) {
            return resource.getContext();
        }
        return null;
    }

    protected final boolean hasSharedContextImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != this.getSharedContextImpl(abstractGraphicsDevice);
    }

    @Override
    protected final GLContext getOrCreateSharedContextImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != resource) {
            return resource.getContext();
        }
        return null;
    }

    @Override
    protected AbstractGraphicsDevice getOrCreateSharedDeviceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != resource) {
            return resource.getDevice();
        }
        return null;
    }

    protected WindowsWGLDrawable getOrCreateSharedDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != resource) {
            return (WindowsWGLDrawable)resource.getDrawable();
        }
        return null;
    }

    SharedResource getOrCreateSharedResource(AbstractGraphicsDevice abstractGraphicsDevice) {
        return (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
    }

    @Override
    protected final void shutdownInstance() {
        this.sharedResourceRunner.releaseAndWait();
        RegisteredClassFactory.shutdownSharedClasses();
    }

    @Override
    protected List getAvailableCapabilitiesImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return WindowsWGLGraphicsConfigurationFactory.getAvailableCapabilities(this, abstractGraphicsDevice);
    }

    @Override
    protected final GLDrawableImpl createOnscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        return new WindowsOnscreenWGLDrawable(this, nativeSurface);
    }

    @Override
    protected final GLDrawableImpl createOffscreenDrawableImpl(final NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            return new WindowsBitmapWGLDrawable(this, nativeSurface);
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        final SharedResource sharedResource = (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null == sharedResource) {
            throw new IllegalArgumentException("No shared resource for " + abstractGraphicsDevice);
        }
        final ArrayList arrayList = new ArrayList();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GLContext gLContext = GLContext.getCurrent();
                if (gLContext != null) {
                    gLContext.release();
                }
                sharedResource.context.makeCurrent();
                try {
                    WindowsPbufferWGLDrawable windowsPbufferWGLDrawable = new WindowsPbufferWGLDrawable(WindowsWGLDrawableFactory.this, nativeSurface, sharedResource.drawable, sharedResource.context);
                    arrayList.add(windowsPbufferWGLDrawable);
                }
                finally {
                    sharedResource.context.release();
                    if (gLContext != null) {
                        gLContext.makeCurrent();
                    }
                }
            }
        };
        this.maybeDoSingleThreadedWorkaround(runnable);
        return (GLDrawableImpl)arrayList.get(0);
    }

    public final int isReadDrawableAvailable(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource = (SharedResource)this.sharedResourceRunner.getOrCreateShared((AbstractGraphicsDevice)(null != abstractGraphicsDevice ? abstractGraphicsDevice : this.defaultDevice));
        if (null != sharedResource) {
            return sharedResource.isReadDrawableAvailable() ? 1 : 0;
        }
        return -1;
    }

    @Override
    public final boolean canCreateGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource = (SharedResource)this.sharedResourceRunner.getOrCreateShared((AbstractGraphicsDevice)(null != abstractGraphicsDevice ? abstractGraphicsDevice : this.defaultDevice));
        if (null != sharedResource) {
            return sharedResource.canCreateGLPbuffer();
        }
        return false;
    }

    @Override
    protected final NativeSurface createOffscreenSurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault((String)"Windows");
        ProxySurface proxySurface = new ProxySurface((AbstractGraphicsConfiguration)WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen));
        proxySurface.setSize(n, n2);
        return proxySurface;
    }

    @Override
    protected final GLContext createExternalGLContextImpl() {
        return WindowsExternalWGLContext.create(this, null);
    }

    @Override
    public final boolean canCreateExternalGLDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return true;
    }

    @Override
    protected final GLDrawable createExternalGLDrawableImpl() {
        return WindowsExternalWGLDrawable.create(this, null);
    }

    static String wglGetLastError() {
        long l = GDI.GetLastError();
        String string = null;
        switch ((int)l) {
            case 0: {
                string = "ERROR_SUCCESS";
                break;
            }
            case 2000: {
                string = "ERROR_INVALID_PIXEL_FORMAT";
                break;
            }
            case 1450: {
                string = "ERROR_NO_SYSTEM_RESOURCES";
                break;
            }
            case 13: {
                string = "ERROR_INVALID_DATA";
                break;
            }
            case 127: {
                string = "ERROR_PROC_NOT_FOUND";
                break;
            }
            case 1400: {
                string = "ERROR_INVALID_WINDOW_HANDLE";
                break;
            }
            default: {
                string = "(Unknown error code " + l + ")";
            }
        }
        return string;
    }

    @Override
    public final boolean canCreateContextOnJava2DSurface(AbstractGraphicsDevice abstractGraphicsDevice) {
        return false;
    }

    @Override
    public final GLContext createContextOnJava2DSurface(Object object, GLContext gLContext) throws GLException {
        throw new GLException("Unimplemented on this platform");
    }

    @Override
    protected final int getGammaRampLength() {
        return 256;
    }

    @Override
    protected final boolean setGammaRamp(float[] fArray) {
        short[] sArray = new short[768];
        for (int i = 0; i < 256; ++i) {
            short s;
            sArray[i] = s = (short)(fArray[i] * 65535.0f);
            sArray[i + 256] = s;
            sArray[i + 512] = s;
        }
        long l = GDI.GetDC((long)0L);
        boolean bl = GDI.SetDeviceGammaRamp((long)l, (Buffer)ShortBuffer.wrap(sArray));
        GDI.ReleaseDC((long)0L, (long)l);
        return bl;
    }

    @Override
    protected final Buffer getGammaRamp() {
        ShortBuffer shortBuffer = ShortBuffer.wrap(new short[768]);
        long l = GDI.GetDC((long)0L);
        boolean bl = GDI.GetDeviceGammaRamp((long)l, (Buffer)shortBuffer);
        GDI.ReleaseDC((long)0L, (long)l);
        if (!bl) {
            return null;
        }
        return shortBuffer;
    }

    @Override
    protected final void resetGammaRamp(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        long l = GDI.GetDC((long)0L);
        GDI.SetDeviceGammaRamp((long)l, (Buffer)buffer);
        GDI.ReleaseDC((long)0L, (long)l);
    }

    static {
        DesktopGLDynamicLookupHelper desktopGLDynamicLookupHelper;
        block3: {
            desktopGLDynamicLookupHelper = null;
            try {
                desktopGLDynamicLookupHelper = new DesktopGLDynamicLookupHelper(new WindowsWGLDynamicLibraryBundleInfo());
            }
            catch (GLException gLException) {
                if (!DEBUG) break block3;
                gLException.printStackTrace();
            }
        }
        windowsWGLDynamicLookupHelper = desktopGLDynamicLookupHelper;
        if (null != windowsWGLDynamicLookupHelper) {
            WGL.getWGLProcAddressTable().reset((DynamicLookupHelper)windowsWGLDynamicLookupHelper);
        }
    }

    class SharedResourceImplementation
    implements SharedResourceRunner.Implementation {
        SharedResourceImplementation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            HashMap hashMap = WindowsWGLDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                WindowsWGLDrawableFactory.this.sharedMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedResourceRunner.Resource mapPut(String string, SharedResourceRunner.Resource resource) {
            HashMap hashMap = WindowsWGLDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                return WindowsWGLDrawableFactory.this.sharedMap.put(string, resource);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedResourceRunner.Resource mapGet(String string) {
            HashMap hashMap = WindowsWGLDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                return (SharedResourceRunner.Resource)WindowsWGLDrawableFactory.this.sharedMap.get(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection mapValues() {
            HashMap hashMap = WindowsWGLDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                return WindowsWGLDrawableFactory.this.sharedMap.values();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedResourceRunner.Resource createSharedResource(String string) {
            WindowsGraphicsDevice windowsGraphicsDevice = new WindowsGraphicsDevice(string, 0);
            windowsGraphicsDevice.lock();
            try {
                boolean bl;
                boolean bl2;
                DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen((AbstractGraphicsDevice)windowsGraphicsDevice, 0);
                if (null == defaultGraphicsScreen) {
                    throw new GLException("Couldn't create shared screen for device: " + windowsGraphicsDevice + ", idx 0");
                }
                GLProfile gLProfile = GLProfile.getMinDesktop((AbstractGraphicsDevice)windowsGraphicsDevice);
                if (null == gLProfile) {
                    throw new GLException("Couldn't get default GLProfile for device: " + windowsGraphicsDevice);
                }
                WindowsDummyWGLDrawable windowsDummyWGLDrawable = WindowsDummyWGLDrawable.create(WindowsWGLDrawableFactory.this, gLProfile, (AbstractGraphicsScreen)defaultGraphicsScreen);
                if (null == windowsDummyWGLDrawable) {
                    throw new GLException("Couldn't create shared drawable for screen: " + defaultGraphicsScreen + ", " + gLProfile);
                }
                WindowsWGLContext windowsWGLContext = (WindowsWGLContext)windowsDummyWGLDrawable.createContext(null);
                if (null == windowsWGLContext) {
                    throw new GLException("Couldn't create shared context for drawable: " + windowsDummyWGLDrawable);
                }
                windowsWGLContext.setSynchronized(true);
                windowsWGLContext.makeCurrent();
                try {
                    bl2 = windowsWGLContext.getGL().isExtensionAvailable(WindowsWGLDrawableFactory.GL_ARB_pbuffer);
                    bl = windowsWGLContext.isExtensionAvailable(WindowsWGLDrawableFactory.WGL_ARB_make_current_read) && windowsWGLContext.isFunctionAvailable(WindowsWGLDrawableFactory.wglMakeContextCurrent);
                }
                finally {
                    windowsWGLContext.release();
                }
                if (DEBUG) {
                    System.err.println("!!! SharedDevice:  " + windowsGraphicsDevice);
                    System.err.println("!!! SharedScreen:  " + defaultGraphicsScreen);
                    System.err.println("!!! SharedContext: " + windowsWGLContext);
                    System.err.println("!!! pbuffer avail: " + bl2);
                    System.err.println("!!! readDrawable:  " + bl);
                }
                SharedResource sharedResource = new SharedResource(windowsGraphicsDevice, (AbstractGraphicsScreen)defaultGraphicsScreen, windowsDummyWGLDrawable, windowsWGLContext, bl, bl2);
                return sharedResource;
            }
            catch (Throwable throwable) {
                throw new GLException("WindowsWGLDrawableFactory - Could not initialize shared resources for " + string, throwable);
            }
            finally {
                windowsGraphicsDevice.unlock();
            }
        }

        @Override
        public void releaseSharedResource(SharedResourceRunner.Resource resource) {
            SharedResource sharedResource = (SharedResource)resource;
            if (DEBUG) {
                System.err.println("!!! Shutdown Shared:");
                System.err.println("!!!   Device  : " + sharedResource.device);
                System.err.println("!!!   Screen  : " + sharedResource.screen);
                System.err.println("!!!   Drawable: " + sharedResource.drawable);
                System.err.println("!!!   CTX     : " + sharedResource.context);
            }
            if (null != sharedResource.context) {
                sharedResource.context = null;
            }
            if (null != sharedResource.drawable) {
                sharedResource.drawable.destroy();
                sharedResource.drawable = null;
            }
            if (null != sharedResource.screen) {
                sharedResource.screen = null;
            }
            if (null != sharedResource.device) {
                sharedResource.device.close();
                sharedResource.device = null;
            }
        }
    }

    static class SharedResource
    implements SharedResourceRunner.Resource {
        private WindowsGraphicsDevice device;
        private AbstractGraphicsScreen screen;
        private WindowsDummyWGLDrawable drawable;
        private WindowsWGLContext context;
        private boolean canCreateGLPbuffer;
        private boolean readDrawableAvailable;

        SharedResource(WindowsGraphicsDevice windowsGraphicsDevice, AbstractGraphicsScreen abstractGraphicsScreen, WindowsDummyWGLDrawable windowsDummyWGLDrawable, WindowsWGLContext windowsWGLContext, boolean bl, boolean bl2) {
            this.device = windowsGraphicsDevice;
            this.screen = abstractGraphicsScreen;
            this.drawable = windowsDummyWGLDrawable;
            this.context = windowsWGLContext;
            this.canCreateGLPbuffer = bl2;
            this.readDrawableAvailable = bl;
        }

        @Override
        public final AbstractGraphicsDevice getDevice() {
            return this.device;
        }

        @Override
        public final AbstractGraphicsScreen getScreen() {
            return this.screen;
        }

        @Override
        public final GLDrawableImpl getDrawable() {
            return this.drawable;
        }

        @Override
        public final GLContextImpl getContext() {
            return this.context;
        }

        final boolean canCreateGLPbuffer() {
            return this.canCreateGLPbuffer;
        }

        final boolean isReadDrawableAvailable() {
            return this.readDrawableAvailable;
        }
    }
}

