/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.macosx.cgl;

import com.jogamp.common.nio.PointerBuffer;
import java.security.AccessController;
import java.util.StringTokenizer;
import javax.media.nativewindow.DefaultGraphicsConfiguration;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextShareSet;
import jogamp.opengl.macosx.cgl.CGL;
import jogamp.opengl.macosx.cgl.MacOSXCGLContext;
import jogamp.opengl.macosx.cgl.MacOSXPbufferCGLDrawable;

public class MacOSXPbufferCGLContext
extends MacOSXCGLContext {
    private int textureTarget;
    private int texture;
    private static boolean isTigerOrLater;
    private boolean haveSetOpenGLMode = false;
    private int openGLMode = 1;
    protected Impl impl;

    public MacOSXPbufferCGLContext(MacOSXPbufferCGLDrawable macOSXPbufferCGLDrawable, GLContext gLContext) {
        super(macOSXPbufferCGLDrawable, gLContext);
        this.initOpenGLImpl();
    }

    @Override
    public void bindPbufferToTexture() {
        GL gL = this.getGL();
        gL.glBindTexture(this.textureTarget, this.texture);
        CGL.setContextTextureImageToPBuffer(this.contextHandle, this.drawable.getHandle(), 1028);
    }

    @Override
    public void releasePbufferFromTexture() {
    }

    @Override
    protected void makeCurrentImpl(boolean bl) throws GLException {
        if (this.getOpenGLMode() != ((MacOSXPbufferCGLDrawable)this.drawable).getOpenGLMode()) {
            this.setOpenGLMode(((MacOSXPbufferCGLDrawable)this.drawable).getOpenGLMode());
        }
        if (!this.impl.makeCurrent(this.contextHandle)) {
            throw new GLException("Error making Context (NS) current");
        }
        if (bl) {
            boolean bl2;
            DefaultGraphicsConfiguration defaultGraphicsConfiguration = (DefaultGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)defaultGraphicsConfiguration.getChosenCapabilities();
            GL gL = this.getGL();
            boolean bl3 = bl2 = gL.isGL2GL3() && gLCapabilitiesImmutable.getPbufferRenderToTextureRectangle();
            if (bl2 && !gL.isExtensionAvailable("GL_EXT_texture_rectangle")) {
                System.err.println("MacOSXPbufferCGLContext: WARNING: GL_EXT_texture_rectangle extension not supported; skipping requested render_to_texture_rectangle support for pbuffer");
                bl2 = false;
            }
            this.textureTarget = bl2 ? 34037 : 3553;
            int[] nArray = new int[1];
            gL.glGenTextures(1, nArray, 0);
            this.texture = nArray[0];
            gL.glBindTexture(this.textureTarget, this.texture);
            gL.glTexParameteri(this.textureTarget, 10241, 9728);
            gL.glTexParameteri(this.textureTarget, 10240, 9728);
            gL.glTexParameteri(this.textureTarget, 10242, 33071);
            gL.glTexParameteri(this.textureTarget, 10243, 33071);
            gL.glCopyTexImage2D(this.textureTarget, 0, 6407, 0, 0, this.drawable.getWidth(), this.drawable.getHeight(), 0);
        }
    }

    @Override
    protected void releaseImpl() throws GLException {
        if (!this.impl.release(this.contextHandle)) {
            throw new GLException("Error releasing OpenGL Context (NS)");
        }
    }

    @Override
    protected void destroyImpl() throws GLException {
        if (!this.impl.destroy(this.contextHandle)) {
            throw new GLException("Unable to delete OpenGL context");
        }
        if (DEBUG) {
            System.err.println("!!! Destroyed OpenGL context " + this.contextHandle);
        }
    }

    @Override
    protected void setSwapIntervalImpl(int n) {
        this.impl.setSwapInterval(this.contextHandle, n);
        this.currentSwapInterval = this.impl.getSwapInterval();
    }

    @Override
    public int getFloatingPointMode() {
        return 1;
    }

    @Override
    protected boolean createImpl() throws GLException {
        DefaultGraphicsConfiguration defaultGraphicsConfiguration = (DefaultGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)defaultGraphicsConfiguration.getChosenCapabilities();
        if (gLCapabilitiesImmutable.getPbufferFloatingPointBuffers() && !isTigerOrLater) {
            throw new GLException("Floating-point pbuffers supported only on OS X 10.4 or later");
        }
        MacOSXCGLContext macOSXCGLContext = (MacOSXCGLContext)GLContextShareSet.getShareContext(this);
        if (macOSXCGLContext != null) {
            this.setOpenGLMode(macOSXCGLContext.getOpenGLMode());
        }
        this.isNSContext = this.impl.isNSContext();
        this.contextHandle = this.impl.create();
        if (!this.impl.makeCurrent(this.contextHandle)) {
            throw new GLException("Error making Context (NS:" + this.isNSContext() + ") current");
        }
        if (!this.isNSContext()) {
            throw new GLException("Not a NS Context");
        }
        this.setGLFunctionAvailability(true, 0, 0, 34);
        return true;
    }

    @Override
    public void setOpenGLMode(int n) {
        if (n == this.openGLMode) {
            return;
        }
        if (this.haveSetOpenGLMode) {
            throw new GLException("Can't switch between using NSOpenGLPixelBuffer and CGLPBufferObj more than once");
        }
        this.destroyImpl();
        ((MacOSXPbufferCGLDrawable)this.drawable).setOpenGLMode(n);
        this.openGLMode = n;
        this.haveSetOpenGLMode = true;
        if (DEBUG) {
            System.err.println("Switching PBuffer context mode to " + (n == 1 ? "NSOPENGL_MODE" : "CGL_MODE"));
        }
        this.initOpenGLImpl();
    }

    @Override
    public int getOpenGLMode() {
        return this.openGLMode;
    }

    private void initOpenGLImpl() {
        switch (this.openGLMode) {
            case 1: {
                this.impl = new NSOpenGLImpl();
                break;
            }
            case 2: {
                this.impl = new CGLImpl();
                break;
            }
            default: {
                throw new InternalError("Illegal implementation mode " + this.openGLMode);
            }
        }
    }

    static {
        String string = Debug.getProperty("os.version", false, AccessController.getContext());
        StringTokenizer stringTokenizer = new StringTokenizer(string, ". ");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        isTigerOrLater = n > 10 || n2 > 3;
    }

    class CGLImpl
    implements Impl {
        CGLImpl() {
        }

        @Override
        public boolean isNSContext() {
            return false;
        }

        @Override
        public long create() {
            long[] lArray;
            PointerBuffer pointerBuffer;
            int n;
            Object object;
            MacOSXCGLContext macOSXCGLContext = (MacOSXCGLContext)GLContextShareSet.getShareContext(MacOSXPbufferCGLContext.this);
            long l = 0L;
            if (macOSXCGLContext != null) {
                if (macOSXCGLContext instanceof MacOSXPbufferCGLContext) {
                    object = (MacOSXPbufferCGLContext)macOSXCGLContext;
                    ((MacOSXPbufferCGLContext)object).setOpenGLMode(2);
                } else if (macOSXCGLContext.isNSContext()) {
                    throw new GLException("Can't share between NSOpenGLContexts and CGLContextObjs");
                }
                l = macOSXCGLContext.getHandle();
            }
            object = new int[256];
            int n2 = 0;
            object[n2++] = 90;
            DefaultGraphicsConfiguration defaultGraphicsConfiguration = (DefaultGraphicsConfiguration)MacOSXPbufferCGLContext.this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)defaultGraphicsConfiguration.getChosenCapabilities();
            if (gLCapabilitiesImmutable.getPbufferFloatingPointBuffers()) {
                object[n2++] = 58;
            }
            if (gLCapabilitiesImmutable.getDoubleBuffered()) {
                object[n2++] = 5;
            }
            if (gLCapabilitiesImmutable.getStereo()) {
                object[n2++] = 6;
            }
            object[n2++] = 8;
            object[n2++] = gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits();
            object[n2++] = 11;
            object[n2++] = gLCapabilitiesImmutable.getAlphaBits();
            object[n2++] = 12;
            object[n2++] = gLCapabilitiesImmutable.getDepthBits();
            object[n2++] = 13;
            object[n2++] = gLCapabilitiesImmutable.getStencilBits();
            object[n2++] = 14;
            object[n2++] = gLCapabilitiesImmutable.getAccumRedBits() + gLCapabilitiesImmutable.getAccumGreenBits() + gLCapabilitiesImmutable.getAccumBlueBits() + gLCapabilitiesImmutable.getAccumAlphaBits();
            if (gLCapabilitiesImmutable.getSampleBuffers()) {
                object[n2++] = 55;
                object[n2++] = true;
                object[n2++] = 56;
                object[n2++] = gLCapabilitiesImmutable.getNumSamples();
            }
            if ((n = CGL.CGLChoosePixelFormat((int[])object, 0, pointerBuffer = PointerBuffer.allocateDirect((int)1), lArray = new long[1], 0)) != 0) {
                throw new GLException("Error code " + n + " while choosing pixel format");
            }
            PointerBuffer pointerBuffer2 = PointerBuffer.allocateDirect((int)1);
            if (DEBUG) {
                System.err.println("Share context for CGL-based pbuffer context is " + MacOSXPbufferCGLContext.toHexString(l));
            }
            n = CGL.CGLCreateContext(pointerBuffer.get(0), l, pointerBuffer2);
            CGL.CGLDestroyPixelFormat(pointerBuffer.get(0));
            if (n != 0) {
                throw new GLException("Error code " + n + " while creating context");
            }
            n = CGL.CGLSetPBuffer(pointerBuffer2.get(0), MacOSXPbufferCGLContext.this.drawable.getHandle(), 0L, 0L, 0L);
            if (n != 0) {
                throw new GLException("Error code " + n + " while attaching context to pbuffer");
            }
            return pointerBuffer2.get(0);
        }

        @Override
        public boolean destroy(long l) {
            return CGL.CGLDestroyContext(l) == 0;
        }

        @Override
        public boolean makeCurrent(long l) {
            return CGL.CGLSetCurrentContext(l) == 0;
        }

        @Override
        public boolean release(long l) {
            return CGL.CGLSetCurrentContext(0L) == 0;
        }

        @Override
        public void setSwapInterval(long l, int n) {
        }

        @Override
        public int getSwapInterval() {
            return 0;
        }
    }

    class NSOpenGLImpl
    implements Impl {
        private int currentSwapInterval = 0;

        NSOpenGLImpl() {
        }

        @Override
        public boolean isNSContext() {
            return true;
        }

        @Override
        public long create() {
            DefaultGraphicsConfiguration defaultGraphicsConfiguration = (DefaultGraphicsConfiguration)MacOSXPbufferCGLContext.this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)defaultGraphicsConfiguration.getChosenCapabilities();
            if (gLCapabilitiesImmutable.getPbufferFloatingPointBuffers() && !isTigerOrLater) {
                throw new GLException("Floating-point pbuffers supported only on OS X 10.4 or later");
            }
            if (!MacOSXPbufferCGLContext.this.create(true, gLCapabilitiesImmutable.getPbufferFloatingPointBuffers())) {
                throw new GLException("Error creating context for pbuffer");
            }
            CGL.setContextPBuffer(MacOSXPbufferCGLContext.this.contextHandle, MacOSXPbufferCGLContext.this.drawable.getHandle());
            return MacOSXPbufferCGLContext.this.contextHandle;
        }

        @Override
        public boolean destroy(long l) {
            return CGL.deleteContext(l);
        }

        @Override
        public boolean makeCurrent(long l) {
            return CGL.makeCurrentContext(l);
        }

        @Override
        public boolean release(long l) {
            return CGL.clearCurrentContext(l);
        }

        @Override
        public void setSwapInterval(long l, int n) {
            CGL.setSwapInterval(l, n);
            this.currentSwapInterval = n;
        }

        @Override
        public int getSwapInterval() {
            return this.currentSwapInterval;
        }
    }

    static interface Impl {
        public boolean isNSContext();

        public long create();

        public boolean destroy(long var1);

        public boolean makeCurrent(long var1);

        public boolean release(long var1);

        public void setSwapInterval(long var1, int var3);

        public int getSwapInterval();
    }
}

