/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class GLBuffers
extends Buffers {
    public static final int sizeOfGLType(int n) {
        switch (n) {
            case 5121: {
                return 1;
            }
            case 5120: {
                return 1;
            }
            case 5123: {
                return 2;
            }
            case 5122: {
                return 2;
            }
            case 5126: {
                return 4;
            }
            case 5132: {
                return 4;
            }
            case 5124: {
                return 4;
            }
            case 5125: {
                return 4;
            }
            case 5130: {
                return 8;
            }
        }
        return -1;
    }

    public static final Buffer newDirectGLBuffer(int n, int n2) {
        switch (n) {
            case 5120: 
            case 5121: {
                return GLBuffers.newDirectByteBuffer((int)n2);
            }
            case 5122: 
            case 5123: {
                return GLBuffers.newDirectShortBuffer((int)n2);
            }
            case 5126: {
                return GLBuffers.newDirectFloatBuffer((int)n2);
            }
            case 5124: 
            case 5125: 
            case 5132: {
                return GLBuffers.newDirectIntBuffer((int)n2);
            }
            case 5130: {
                return GLBuffers.newDirectDoubleBuffer((int)n2);
            }
        }
        return null;
    }

    public static final Buffer sliceGLBuffer(ByteBuffer byteBuffer, int n, int n2, int n3) {
        if (byteBuffer == null || n2 == 0) {
            return null;
        }
        byteBuffer.position(n);
        byteBuffer.limit(n + n2);
        switch (n3) {
            case 5120: 
            case 5121: {
                return byteBuffer.slice();
            }
            case 5122: 
            case 5123: {
                return byteBuffer.asShortBuffer();
            }
            case 5126: {
                return byteBuffer.asFloatBuffer();
            }
            case 5124: 
            case 5125: 
            case 5132: {
                return byteBuffer.asIntBuffer();
            }
            case 5130: {
                return byteBuffer.asDoubleBuffer();
            }
        }
        return null;
    }

    public static final float[] getFloatArray(double[] dArray) {
        int n = dArray.length;
        float[] fArray = new float[n--];
        while (n >= 0) {
            fArray[n] = (float)dArray[n];
            --n;
        }
        return fArray;
    }
}

