/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.progressbar;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.examples.NiftyExample;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

public class ProgressbarControl
implements Controller,
NiftyExample {
    private Element progressBarElement;
    private Element progressTextElement;

    public void bind(Nifty nifty, Screen screenParam, Element element, Properties parameter, Attributes controlDefinitionAttributes) {
        this.progressBarElement = element.findElementByName("#progress");
        this.progressTextElement = element.findElementByName("#progress-text");
    }

    public void init(Properties parameter, Attributes controlDefinitionAttributes) {
    }

    public void onStartScreen() {
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    public void setProgress(float progressValue) {
        float progress = progressValue;
        if (progress < 0.0f) {
            progress = 0.0f;
        } else if (progress > 1.0f) {
            progress = 1.0f;
        }
        int MIN_WIDTH = 32;
        int pixelWidth = (int)(32.0f + (float)(this.progressBarElement.getParent().getWidth() - 32) * progress);
        this.progressBarElement.setConstraintWidth(new SizeValue(pixelWidth + "px"));
        this.progressBarElement.getParent().layoutElements();
        String progressText = String.format("%3.0f%%", Float.valueOf(progress * 100.0f));
        ((TextRenderer)this.progressTextElement.getRenderer(TextRenderer.class)).setText(progressText);
    }

    @Override
    public String getStartScreen() {
        return "start";
    }

    @Override
    public String getMainXML() {
        return "progressbar/progressbar.xml";
    }

    @Override
    public String getTitle() {
        return "Nifty Progressbar Example";
    }

    @Override
    public void prepareStart(Nifty nifty) {
    }
}

