/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Sink;
import com.fluendo.utils.Debug;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageProducer;

public class VideoSink
extends Sink {
    private Component component;
    private boolean keepAspect = true;
    private boolean ignoreAspect;
    private boolean scale = true;
    private Frame frame;
    private int width;
    private int height;
    private int aspectX;
    private int aspectY;
    private Rectangle bounds = null;

    protected boolean setCapsFunc(Caps caps) {
        String mime = caps.getMime();
        if (!mime.equals("video/raw")) {
            return false;
        }
        this.width = caps.getFieldInt("width", -1);
        this.height = caps.getFieldInt("height", -1);
        if (this.width == -1 || this.height == -1) {
            return false;
        }
        this.aspectX = caps.getFieldInt("aspect_x", 1);
        this.aspectY = caps.getFieldInt("aspect_y", 1);
        if (!this.ignoreAspect) {
            Debug.log(4, this + " dimension: " + this.width + "x" + this.height + ", aspect: " + this.aspectX + "/" + this.aspectY);
            if (this.aspectY > this.aspectX) {
                this.height = this.height * this.aspectY / this.aspectX;
            } else {
                this.width = this.width * this.aspectX / this.aspectY;
            }
            Debug.log(4, this + " scaled source: " + this.width + "x" + this.height);
        }
        this.component.setVisible(true);
        return true;
    }

    protected int preroll(Buffer buf) {
        return this.render(buf);
    }

    protected int render(Buffer buf) {
        if (!buf.duplicate) {
            int y;
            int x;
            int h;
            int w;
            Image image;
            Debug.log(4, this.getName() + " starting buffer " + buf);
            if (buf.object instanceof ImageProducer) {
                image = this.component.createImage((ImageProducer)buf.object);
            } else if (buf.object instanceof Image) {
                image = (Image)buf.object;
            } else {
                System.out.println(this + ": unknown buffer received " + buf);
                return -5;
            }
            if (!this.component.isVisible()) {
                return -4;
            }
            Graphics graphics = this.component.getGraphics();
            if (this.keepAspect) {
                double dst_ratio;
                double src_ratio;
                if (this.bounds == null) {
                    this.bounds = new Rectangle(this.component.getSize());
                }
                if ((src_ratio = (double)this.width / (double)this.height) > (dst_ratio = (double)this.bounds.width / (double)this.bounds.height)) {
                    w = this.bounds.width;
                    h = (int)((double)this.bounds.width / src_ratio);
                    x = this.bounds.x;
                    y = this.bounds.y + (this.bounds.height - h) / 2;
                } else if (src_ratio < dst_ratio) {
                    w = (int)((double)this.bounds.height * src_ratio);
                    h = this.bounds.height;
                    x = this.bounds.x + (this.bounds.width - w) / 2;
                    y = this.bounds.y;
                } else {
                    x = this.bounds.x;
                    y = this.bounds.y;
                    w = this.bounds.width;
                    h = this.bounds.height;
                }
            } else if (!this.scale) {
                w = Math.min(this.width, this.bounds.width);
                h = Math.min(this.height, this.bounds.height);
                x = this.bounds.x + (this.bounds.width - w) / 2;
                y = this.bounds.y + (this.bounds.height - h) / 2;
            } else {
                w = this.bounds.width;
                h = this.bounds.height;
                x = 0;
                y = 0;
            }
            graphics.drawImage(image, x, y, w, h, null);
            Debug.log(4, this.getName() + " done with buffer " + buf);
        }
        return 0;
    }

    public String getFactoryName() {
        return "videosink";
    }

    public boolean setProperty(String name, Object value) {
        if (name.equals("component")) {
            this.component = (Component)value;
        } else if (name.equals("keep-aspect")) {
            this.keepAspect = String.valueOf(value).equals("true");
        } else if (name.equals("ignore-aspect")) {
            this.ignoreAspect = value.toString().equals("true");
        } else if (name.equals("scale")) {
            this.scale = String.valueOf(value).equals("true");
        } else if (name.equals("bounds")) {
            this.bounds = (Rectangle)value;
            Debug.info("Video bounding rectangle: x=" + this.bounds.x + ", y=" + this.bounds.y + ", w=" + this.bounds.width + ", h=" + this.bounds.height);
        } else {
            return super.setProperty(name, value);
        }
        return true;
    }

    public Object getProperty(String name) {
        if (name.equals("component")) {
            return this.component;
        }
        if (name.equals("keep-aspect")) {
            return this.keepAspect ? "true" : "false";
        }
        if (name.equals("bounds")) {
            return this.bounds;
        }
        return super.getProperty(name);
    }

    protected int changeState(int transition) {
        if (this.currentState == 1 && this.pendingState == 2 && this.component == null) {
            this.frame = new Frame();
            this.component = this.frame;
        }
        return super.changeState(transition);
    }
}

