/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Event;
import com.fluendo.jst.Pad;
import com.fluendo.jtiger.Renderer;
import com.fluendo.plugin.Overlay;
import com.fluendo.utils.Debug;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.ImageProducer;

public class KateOverlay
extends Overlay {
    private Font font = null;
    private String text = null;
    private Renderer tr = new Renderer();
    private Dimension image_dimension = null;
    private Pad kateSinkPad = new Pad(2, "katesink"){

        protected boolean eventFunc(Event event) {
            switch (event.getType()) {
                case 1: 
                case 2: 
                case 4: {
                    KateOverlay.this.onFlush();
                    break;
                }
            }
            return true;
        }

        protected synchronized int chainFunc(Buffer buf) {
            KateOverlay.this.addKateEvent((com.fluendo.jkate.Event)buf.object);
            return 0;
        }
    };

    public KateOverlay() {
        this.addPad(this.kateSinkPad);
    }

    protected synchronized void addKateEvent(com.fluendo.jkate.Event ev) {
        this.tr.add(ev);
        Debug.log(4, "Kate overlay got Kate event: " + new String(ev.text));
    }

    protected synchronized void onFlush() {
        this.tr.flush();
        this.image_dimension = null;
        Debug.log(4, "Kate overlay flushing");
    }

    protected Image getImage(Buffer buf) {
        Image img;
        if (buf.object instanceof ImageProducer) {
            img = this.component.createImage((ImageProducer)buf.object);
        } else if (buf.object instanceof Image) {
            img = (Image)buf.object;
        } else {
            System.out.println(this + ": unknown buffer received " + buf);
            img = null;
        }
        return img;
    }

    protected synchronized void overlay(Buffer buf) {
        int ret;
        Image img = null;
        if (this.image_dimension == null) {
            img = this.getImage(buf);
            if (img == null) {
                return;
            }
            this.image_dimension = new Dimension(img.getWidth(null), img.getHeight(null));
        }
        if ((ret = this.tr.update(this.component, this.image_dimension, (double)buf.timestamp / 1000000.0)) < 0) {
            Debug.log(2, "Failed to update jtiger renderer");
            return;
        }
        if (!buf.duplicate && ret > 0) {
            Debug.log(4, "Video frame is not a dupe and we have nothing to overlay.");
            return;
        }
        if (buf.duplicate && !this.tr.isDirty()) {
            Debug.log(4, "Video frame is a dupe and we're not dirty. Yeah.");
            return;
        }
        if (img == null) {
            img = this.getImage(buf);
        }
        img = this.tr.render(this.component, img);
        buf.duplicate = false;
        buf.object = img;
    }

    public String getFactoryName() {
        return "kateoverlay";
    }
}

