/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jtiger;

import com.fluendo.jkate.Event;
import com.fluendo.jtiger.Item;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

public class Renderer {
    private Vector items = new Vector();
    private boolean dirty = true;

    public void add(Event ev) {
        this.items.addElement(new Item(ev));
        this.dirty = true;
    }

    public int update(Component c, Dimension d, double t) {
        for (int n = 0; n < this.items.size(); ++n) {
            boolean ret = ((Item)this.items.elementAt(n)).update(c, d, t);
            if (!ret) {
                this.items.removeElementAt(n);
                this.dirty = true;
                --n;
                continue;
            }
            if (!((Item)this.items.elementAt(n)).isDirty()) continue;
            this.dirty = true;
        }
        if (this.items.size() == 0) {
            return 1;
        }
        return 0;
    }

    public Image render(Component c, Image img) {
        Image copy = c.createImage(img.getWidth(null), img.getHeight(null));
        Graphics g = copy.getGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        img = copy;
        for (int n = 0; n < this.items.size(); ++n) {
            ((Item)this.items.elementAt(n)).render(c, img);
        }
        this.dirty = false;
        return img;
    }

    public void flush() {
        this.items.removeAllElements();
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

