/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dragndrop.controller;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyMethodInvoker;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.NiftyInputControl;
import de.lessvoid.nifty.controls.dragndrop.controller.DragNotify;
import de.lessvoid.nifty.controls.dragndrop.controller.DroppableControl;
import de.lessvoid.nifty.elements.ControllerEventListener;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class DraggableControl
implements Controller {
    private static final String POPUP = "draggablePopup";
    private static final Logger logger = Logger.getLogger(DraggableControl.class.getName());
    private Nifty nifty;
    private Screen screen;
    private Element draggable;
    private Element originalParent;
    private Element popup;
    private Element handle;
    private boolean revert;
    private boolean dropEnabled;
    private List<DragNotify> notifies = new CopyOnWriteArrayList<DragNotify>();
    private boolean dragged = false;
    private int originalPositionX;
    private int originalPositionY;
    private SizeValue originalConstraintX;
    private SizeValue originalConstraintY;
    private int dragStartX;
    private int dragStartY;
    private DroppableControl droppable;

    public void bind(Nifty nifty, Screen screen, Element element, Properties parameter, ControllerEventListener listener, Attributes controlDefinitionAttributes) {
        this.nifty = nifty;
        this.screen = screen;
        this.draggable = element;
        String handleId = controlDefinitionAttributes.get("handle");
        this.handle = this.draggable.findElementByName(handleId);
        if (this.handle == null) {
            this.handle = this.draggable;
        }
        this.revert = controlDefinitionAttributes.getAsBoolean("revert", true);
        this.dropEnabled = controlDefinitionAttributes.getAsBoolean("drop", true);
        this.addOnDragStartMethodNotify(controlDefinitionAttributes.get("onDragStart"));
        this.addOnDragCancelMethodNotify(controlDefinitionAttributes.get("onDragCancel"));
    }

    private void addOnDragStartMethodNotify(String methodName) {
        if (methodName != null) {
            this.addNotify(new OnDragStartMethodNotify(methodName));
        }
    }

    private void addOnDragCancelMethodNotify(String methodName) {
        if (methodName != null) {
            this.addNotify(new OnDragCancelMethodNotify(methodName));
        }
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    public void onFocus(boolean getFocus) {
    }

    public void onStartScreen() {
    }

    public void dragStart(int mouseX, int mouseY) {
        System.out.println("dragStart(" + this.dragged + ")");
        if (this.dragged) {
            return;
        }
        this.originalParent = this.draggable.getParent();
        this.originalPositionX = this.draggable.getX();
        this.originalPositionY = this.draggable.getY();
        this.originalConstraintX = this.draggable.getConstraintX();
        this.originalConstraintY = this.draggable.getConstraintY();
        this.dragStartX = mouseX;
        this.dragStartY = mouseY;
        if (this.handle.isMouseInsideElement(mouseX, mouseY)) {
            this.moveDraggableToPopup();
            this.dragged = true;
            this.notifyObserversDragStarted();
        } else {
            this.moveDraggableOnTop();
        }
    }

    private void moveDraggableToPopup() {
        this.popup = this.nifty.createPopup(POPUP);
        this.draggable.markForMove(this.popup, new EndNotify(){

            public void perform() {
                DraggableControl.this.draggable.setConstraintX(new SizeValue(DraggableControl.this.originalPositionX + "px"));
                DraggableControl.this.draggable.setConstraintY(new SizeValue(DraggableControl.this.originalPositionY + "px"));
                DraggableControl.this.nifty.showPopup(DraggableControl.this.screen, DraggableControl.POPUP, null);
            }
        });
    }

    private void moveDraggableOnTop() {
        this.draggable.markForMove(this.originalParent, new EndNotify(){

            public void perform() {
                DraggableControl.this.draggable.reactivate();
            }
        });
    }

    public void drag(int mouseX, int mouseY) {
        if (!this.dragged) {
            return;
        }
        int newPositionX = this.originalPositionX + mouseX - this.dragStartX;
        int newPositionY = this.originalPositionY + mouseY - this.dragStartY;
        this.draggable.setConstraintX(new SizeValue(newPositionX + "px"));
        this.draggable.setConstraintY(new SizeValue(newPositionY + "px"));
        this.popup.layoutElements();
    }

    public void dragStop() {
        if (!this.dragged) {
            return;
        }
        logger.fine("dragStop()");
        Element newDroppable = this.findDroppableAtCurrentCoordinates();
        if (newDroppable == this.originalParent) {
            this.dragCancel();
        } else {
            DroppableControl droppableControl = (DroppableControl)newDroppable.getControl(DroppableControl.class);
            if (droppableControl.accept(this.droppable, this)) {
                droppableControl.drop(this, this.closePopup());
            } else {
                this.dragCancel();
            }
        }
        this.dragged = false;
    }

    private void dragCancel() {
        if (this.revert) {
            this.draggable.setConstraintX(this.originalConstraintX);
            this.draggable.setConstraintY(this.originalConstraintY);
        } else {
            this.draggable.setConstraintX(new SizeValue(this.draggable.getX() + "px"));
            this.draggable.setConstraintY(new SizeValue(this.draggable.getY() + "px"));
        }
        this.moveDraggableBackToOriginalParent();
        this.notifyObserversDragCanceled();
    }

    private EndNotify closePopup() {
        return new EndNotify(){

            public void perform() {
                DraggableControl.this.nifty.closePopup(DraggableControl.POPUP, new EndNotify(){

                    public void perform() {
                        DraggableControl.this.draggable.reactivate();
                    }
                });
            }
        };
    }

    private void moveDraggableBackToOriginalParent() {
        this.draggable.markForMove(this.originalParent, this.closePopup());
    }

    private Element findDroppableAtCurrentCoordinates() {
        if (this.dropEnabled) {
            int dragAnkerX = this.draggable.getX() + this.draggable.getWidth() / 2;
            int dragAnkerY = this.draggable.getY() + this.draggable.getHeight() / 2;
            List layers = this.screen.getLayerElements();
            ListIterator iter = layers.listIterator(layers.size());
            while (iter.hasPrevious()) {
                Element droppable;
                Element layer = (Element)iter.previous();
                if (layer == this.popup || (droppable = this.findDroppableAtCoordinates(layer, dragAnkerX, dragAnkerY)) == null) continue;
                return droppable;
            }
        }
        return this.originalParent;
    }

    private Element findDroppableAtCoordinates(Element context, int x, int y) {
        List elements = context.getElements();
        ListIterator iter = elements.listIterator(elements.size());
        while (iter.hasPrevious()) {
            Element element = (Element)iter.previous();
            boolean mouseInside = element.isMouseInsideElement(x, y);
            if (mouseInside && this.isDroppable(element)) {
                return element;
            }
            Element droppable = this.findDroppableAtCoordinates(element, x, y);
            if (droppable != null) {
                return droppable;
            }
            if (!mouseInside || !element.isVisibleToMouseEvents()) continue;
            return this.originalParent;
        }
        return null;
    }

    private boolean isDroppable(Element element) {
        NiftyInputControl control = element.getAttachedInputControl();
        if (control != null) {
            return control.getController() instanceof DroppableControl;
        }
        return false;
    }

    public Element getElement() {
        return this.draggable;
    }

    public DroppableControl getDroppable() {
        return this.droppable;
    }

    protected void setDroppable(DroppableControl droppable) {
        this.droppable = droppable;
    }

    public void addNotify(DragNotify notify) {
        this.notifies.add(notify);
    }

    public void removeNotify(DragNotify notify) {
        this.notifies.remove(notify);
    }

    public void removeAllNotifies() {
        this.notifies.clear();
    }

    private void notifyObserversDragStarted() {
        for (DragNotify notify : this.notifies) {
            notify.dragStarted(this.droppable, this);
        }
    }

    private void notifyObserversDragCanceled() {
        for (DragNotify notify : this.notifies) {
            notify.dragCanceled(this.droppable, this);
        }
    }

    private class OnDragCancelMethodNotify
    implements DragNotify {
        private String methodName;

        public OnDragCancelMethodNotify(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public void dragStarted(DroppableControl source, DraggableControl draggable) {
        }

        @Override
        public void dragCanceled(DroppableControl source, DraggableControl draggable) {
            NiftyMethodInvoker methodInvoker = new NiftyMethodInvoker(DraggableControl.this.nifty, this.methodName, new Object[]{DraggableControl.this.screen.getScreenController()});
            methodInvoker.invoke(new Object[]{source, draggable});
        }
    }

    private class OnDragStartMethodNotify
    implements DragNotify {
        private String methodName;

        public OnDragStartMethodNotify(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public void dragStarted(DroppableControl source, DraggableControl draggable) {
            NiftyMethodInvoker methodInvoker = new NiftyMethodInvoker(DraggableControl.this.nifty, this.methodName, new Object[]{DraggableControl.this.screen.getScreenController()});
            methodInvoker.invoke(new Object[]{source, draggable});
        }

        @Override
        public void dragCanceled(DroppableControl source, DraggableControl draggable) {
        }
    }
}

