/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.text.MaximumCapacityPatternCache;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.oro.text.PatternCache;
import org.apache.oro.text.perl.Perl5Util;

public class MetricsConfiguration {
    private static final Perl5Util perl = new Perl5Util((PatternCache)new MaximumCapacityPatternCache());
    private List<MeasurementDescriptor> projectMeasurements = new LinkedList<MeasurementDescriptor>();
    private List<MeasurementDescriptor> groupMeasurements = new LinkedList<MeasurementDescriptor>();
    private List<MeasurementDescriptor> classMeasurements = new LinkedList<MeasurementDescriptor>();
    private List<MeasurementDescriptor> methodMeasurements = new LinkedList<MeasurementDescriptor>();
    private Map<String, Collection<String>> groupDefinitions = new HashMap<String, Collection<String>>();

    public List<MeasurementDescriptor> getProjectMeasurements() {
        return Collections.unmodifiableList(this.projectMeasurements);
    }

    public void addProjectMeasurement(MeasurementDescriptor descriptor) {
        this.projectMeasurements.add(descriptor);
    }

    public List<MeasurementDescriptor> getGroupMeasurements() {
        return Collections.unmodifiableList(this.groupMeasurements);
    }

    public void addGroupMeasurement(MeasurementDescriptor descriptor) {
        this.groupMeasurements.add(descriptor);
    }

    public List<MeasurementDescriptor> getClassMeasurements() {
        return Collections.unmodifiableList(this.classMeasurements);
    }

    public void addClassMeasurement(MeasurementDescriptor descriptor) {
        this.classMeasurements.add(descriptor);
    }

    public List<MeasurementDescriptor> getMethodMeasurements() {
        return Collections.unmodifiableList(this.methodMeasurements);
    }

    public void addMethodMeasurement(MeasurementDescriptor descriptor) {
        this.methodMeasurements.add(descriptor);
    }

    public void addGroupDefinition(String name, String pattern) {
        Collection<String> bucket = this.groupDefinitions.get(name);
        if (bucket == null) {
            bucket = new LinkedList<String>();
            this.groupDefinitions.put(name, bucket);
        }
        bucket.add(pattern);
    }

    public Collection<String> getGroups(String name) {
        HashSet<String> result = new HashSet<String>();
        for (String key : this.groupDefinitions.keySet()) {
            if (this.groupDefinitions.get(key) == null) continue;
            for (String pattern : this.groupDefinitions.get(key)) {
                if (!perl.match(pattern, name)) continue;
                result.add(key);
            }
        }
        return result;
    }
}

