/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.diff;

import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.diff.ClassDifferences;
import com.jeantessier.diff.ClassReport;
import com.jeantessier.diff.Differences;
import com.jeantessier.diff.InterfaceDifferences;
import com.jeantessier.diff.PackageDifferences;
import com.jeantessier.diff.Printer;
import com.jeantessier.diff.ProjectDifferences;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class Report
extends Printer {
    public static final String DEFAULT_ENCODING = "utf-8";
    public static final String DEFAULT_DTD_PREFIX = "http://depfind.sourceforge.net/dtd";
    private String name;
    private String oldVersion;
    private String newVersion;
    private Collection<Differences> removedPackages = new TreeSet<Differences>();
    private Collection<ClassDifferences> removedInterfaces = new TreeSet<ClassDifferences>();
    private Collection<ClassDifferences> removedClasses = new TreeSet<ClassDifferences>();
    private Collection<ClassDifferences> deprecatedInterfaces = new TreeSet<ClassDifferences>();
    private Collection<ClassDifferences> deprecatedClasses = new TreeSet<ClassDifferences>();
    private Collection<ClassReport> modifiedInterfaces = new TreeSet<ClassReport>();
    private Collection<ClassReport> modifiedClasses = new TreeSet<ClassReport>();
    private Collection<ClassDifferences> undeprecatedInterfaces = new TreeSet<ClassDifferences>();
    private Collection<ClassDifferences> undeprecatedClasses = new TreeSet<ClassDifferences>();
    private Collection<Differences> newPackages = new TreeSet<Differences>();
    private Collection<ClassDifferences> newInterfaces = new TreeSet<ClassDifferences>();
    private Collection<ClassDifferences> newClasses = new TreeSet<ClassDifferences>();

    public Report() {
        this(DEFAULT_ENCODING, DEFAULT_DTD_PREFIX);
    }

    public Report(String encoding, String dtdPrefix) {
        this.appendHeader(encoding, dtdPrefix);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOldVersion(String oldVersion) {
        this.oldVersion = oldVersion;
    }

    public void setNewVersion(String newVersion) {
        this.newVersion = newVersion;
    }

    private void appendHeader(String encoding, String dtdPrefix) {
        this.append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\" ?>").eol();
        this.eol();
        this.append("<!DOCTYPE differences SYSTEM \"").append(dtdPrefix).append("/differences.dtd\">").eol();
        this.eol();
    }

    @Override
    public void visitProjectDifferences(ProjectDifferences differences) {
        this.setName(differences.getName());
        this.setOldVersion(differences.getOldVersion());
        this.setNewVersion(differences.getNewVersion());
        for (Differences packageDifference : differences.getPackageDifferences()) {
            packageDifference.accept(this);
        }
    }

    @Override
    public void visitPackageDifferences(PackageDifferences differences) {
        if (differences.isRemoved()) {
            this.removedPackages.add(differences);
        }
        for (Differences classDiffenrence : differences.getClassDifferences()) {
            classDiffenrence.accept(this);
        }
        if (differences.isNew()) {
            this.newPackages.add(differences);
        }
    }

    @Override
    public void visitClassDifferences(ClassDifferences differences) {
        if (differences.isRemoved()) {
            this.removedClasses.add(differences);
        }
        if (differences.isModified()) {
            ClassReport visitor = new ClassReport();
            visitor.setIndentText(this.getIndentText());
            differences.accept(visitor);
            this.modifiedClasses.add(visitor);
        }
        if (differences.isNew()) {
            this.newClasses.add(differences);
        }
        if (this.isDeprecated()) {
            this.deprecatedClasses.add(differences);
        }
        if (this.isUndeprecated()) {
            this.undeprecatedClasses.add(differences);
        }
    }

    @Override
    public void visitInterfaceDifferences(InterfaceDifferences differences) {
        if (differences.isRemoved()) {
            this.removedInterfaces.add(differences);
        }
        if (differences.isModified()) {
            ClassReport classReport = new ClassReport();
            classReport.setIndentText(this.getIndentText());
            differences.accept(classReport);
            this.modifiedInterfaces.add(classReport);
        }
        if (differences.isNew()) {
            this.newInterfaces.add(differences);
        }
        if (this.isDeprecated()) {
            this.deprecatedInterfaces.add(differences);
        }
        if (this.isUndeprecated()) {
            this.undeprecatedInterfaces.add(differences);
        }
    }

    public String render() {
        this.indent().append("<differences>").eol();
        this.raiseIndent();
        this.indent().append("<name>").append(this.name).append("</name>").eol();
        this.indent().append("<old>").append(this.oldVersion).append("</old>").eol();
        this.indent().append("<new>").append(this.newVersion).append("</new>").eol();
        if (this.removedPackages.size() != 0) {
            this.indent().append("<removed-packages>").eol();
            this.raiseIndent();
            for (Differences removedPackage : this.removedPackages) {
                this.indent().append("<name>").append(removedPackage).append("</name>").eol();
            }
            this.lowerIndent();
            this.indent().append("</removed-packages>").eol();
        }
        if (this.removedInterfaces.size() != 0) {
            this.indent().append("<removed-interfaces>").eol();
            this.raiseIndent();
            for (ClassDifferences cd : this.removedInterfaces) {
                this.indent().append("<name").append(this.breakdownDeclaration(cd.getOldClass())).append(">").append(cd).append("</name>").eol();
            }
            this.lowerIndent();
            this.indent().append("</removed-interfaces>").eol();
        }
        if (this.removedClasses.size() != 0) {
            this.indent().append("<removed-classes>").eol();
            this.raiseIndent();
            for (ClassDifferences cd : this.removedClasses) {
                this.indent().append("<name").append(this.breakdownDeclaration(cd.getOldClass())).append(">").append(cd).append("</name>").eol();
            }
            this.lowerIndent();
            this.indent().append("</removed-classes>").eol();
        }
        if (this.deprecatedInterfaces.size() != 0) {
            this.indent().append("<deprecated-interfaces>").eol();
            this.raiseIndent();
            for (ClassDifferences cd : this.deprecatedInterfaces) {
                this.indent().append("<name").append(this.breakdownDeclaration(cd.getNewClass())).append(">").append(cd).append("</name>").eol();
            }
            this.lowerIndent();
            this.indent().append("</deprecated-interfaces>").eol();
        }
        if (this.deprecatedClasses.size() != 0) {
            this.indent().append("<deprecated-classes>").eol();
            this.raiseIndent();
            for (ClassDifferences cd : this.deprecatedClasses) {
                this.indent().append("<name").append(this.breakdownDeclaration(cd.getNewClass())).append(">").append(cd).append("</name>").eol();
            }
            this.lowerIndent();
            this.indent().append("</deprecated-classes>").eol();
        }
        if (this.modifiedInterfaces.size() != 0) {
            this.indent().append("<modified-interfaces>").eol();
            this.raiseIndent();
            for (ClassReport modifiedInterface : this.modifiedInterfaces) {
                this.append(modifiedInterface.render());
            }
            this.lowerIndent();
            this.indent().append("</modified-interfaces>").eol();
        }
        if (this.modifiedClasses.size() != 0) {
            this.indent().append("<modified-classes>").eol();
            this.raiseIndent();
            for (ClassReport modifiedClass : this.modifiedClasses) {
                this.append(modifiedClass.render());
            }
            this.lowerIndent();
            this.indent().append("</modified-classes>").eol();
        }
        if (this.undeprecatedInterfaces.size() != 0) {
            this.indent().append("<undeprecated-interfaces>").eol();
            this.raiseIndent();
            for (ClassDifferences cd : this.undeprecatedInterfaces) {
                this.indent().append("<name").append(this.breakdownDeclaration(cd.getNewClass())).append(">").append(cd).append("</name>").eol();
            }
            this.lowerIndent();
            this.indent().append("</undeprecated-interfaces>").eol();
        }
        if (this.undeprecatedClasses.size() != 0) {
            this.indent().append("<undeprecated-classes>").eol();
            this.raiseIndent();
            for (ClassDifferences cd : this.undeprecatedClasses) {
                this.indent().append("<name").append(this.breakdownDeclaration(cd.getNewClass())).append(">").append(cd).append("</name>").eol();
            }
            this.lowerIndent();
            this.indent().append("</undeprecated-classes>").eol();
        }
        if (this.newPackages.size() != 0) {
            this.indent().append("<new-packages>").eol();
            this.raiseIndent();
            for (Differences newPackage : this.newPackages) {
                this.indent().append("<name>").append(newPackage).append("</name>").eol();
            }
            this.lowerIndent();
            this.indent().append("</new-packages>").eol();
        }
        if (this.newInterfaces.size() != 0) {
            this.indent().append("<new-interfaces>").eol();
            this.raiseIndent();
            for (ClassDifferences cd : this.newInterfaces) {
                this.indent().append("<name").append(this.breakdownDeclaration(cd.getNewClass())).append(">").append(cd).append("</name>").eol();
            }
            this.lowerIndent();
            this.indent().append("</new-interfaces>").eol();
        }
        if (this.newClasses.size() != 0) {
            this.indent().append("<new-classes>").eol();
            this.raiseIndent();
            for (ClassDifferences cd : this.newClasses) {
                this.indent().append("<name").append(this.breakdownDeclaration(cd.getNewClass())).append(">").append(cd).append("</name>").eol();
            }
            this.lowerIndent();
            this.indent().append("</new-classes>").eol();
        }
        this.lowerIndent();
        this.indent().append("</differences>").eol();
        return super.toString();
    }

    private String breakdownDeclaration(Classfile element) {
        StringBuffer result = new StringBuffer();
        if (element != null) {
            if (element.isPublic()) {
                result.append(" visibility=\"public\"");
            }
            if (element.isPackage()) {
                result.append(" visibility=\"package\"");
            }
            if (element.isFinal()) {
                result.append(" final=\"yes\"");
            }
            if (element.isSuper()) {
                result.append(" super=\"yes\"");
            }
            if (element.isSynthetic()) {
                result.append(" synthetic=\"yes\"");
            }
            if (element.isDeprecated()) {
                result.append(" deprecated=\"yes\"");
            }
            result.append(" name=\"").append(element.getClassName()).append("\"");
            if (element.isInterface()) {
                result.append(" interface=\"yes\"");
                result.append(" extends=\"");
                Iterator<? extends Class_info> i = element.getAllInterfaces().iterator();
                while (i.hasNext()) {
                    result.append(i.next());
                    if (!i.hasNext()) continue;
                    result.append(", ");
                }
                result.append("\"");
            } else {
                if (element.isAbstract()) {
                    result.append(" abstract=\"yes\"");
                }
                result.append(" extends=\"").append(element.getSuperclassName()).append("\"");
                result.append(" implements=\"");
                Iterator<? extends Class_info> i = element.getAllInterfaces().iterator();
                while (i.hasNext()) {
                    result.append(i.next());
                    if (!i.hasNext()) continue;
                    result.append(", ");
                }
                result.append("\"");
            }
        }
        return result.toString();
    }
}

