/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.diff;

import com.jeantessier.classreader.Classfile;
import com.jeantessier.diff.Differences;
import com.jeantessier.diff.RemovableDifferences;
import com.jeantessier.diff.Visitor;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class ClassDifferences
extends RemovableDifferences {
    private Classfile oldClass;
    private Classfile newClass;
    private boolean declarationModified;
    private Collection<Differences> featureDifferences = new LinkedList<Differences>();

    ClassDifferences(String name, Classfile oldClass, Classfile newClass) {
        super(name);
        this.setOldClass(oldClass);
        this.setNewClass(newClass);
        if (this.isModified()) {
            Logger.getLogger(this.getClass()).debug((Object)(this.getName() + " declaration has been modified."));
        } else {
            Logger.getLogger(this.getClass()).debug((Object)(this.getName() + " declaration has not been modified."));
        }
    }

    public Classfile getOldClass() {
        return this.oldClass;
    }

    protected void setOldClass(Classfile oldClass) {
        this.oldClass = oldClass;
    }

    public Classfile getNewClass() {
        return this.newClass;
    }

    protected void setNewClass(Classfile newClass) {
        this.newClass = newClass;
    }

    @Override
    public String getOldDeclaration() {
        String result = null;
        if (this.getOldClass() != null) {
            result = this.getOldClass().getDeclaration();
        }
        return result;
    }

    @Override
    public String getNewDeclaration() {
        String result = null;
        if (this.getNewClass() != null) {
            result = this.getNewClass().getDeclaration();
        }
        return result;
    }

    public boolean isDeclarationModified() {
        return this.declarationModified;
    }

    void setDeclarationModified(boolean declarationModified) {
        this.declarationModified = declarationModified;
    }

    public Collection<Differences> getFeatureDifferences() {
        return this.featureDifferences;
    }

    @Override
    public boolean isModified() {
        return this.isDeclarationModified() || this.getFeatureDifferences().size() != 0;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitClassDifferences(this);
    }
}

