/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.classreader.LoadEvent;
import com.jeantessier.dependencyfinder.VerboseListenerBase;
import com.jeantessier.dependencyfinder.gui.StatusLine;
import javax.swing.JProgressBar;

public class VerboseListener
extends VerboseListenerBase {
    private StatusLine statusLine;
    private JProgressBar progressBar;

    public VerboseListener(StatusLine statusLine, JProgressBar progressBar) {
        this.statusLine = statusLine;
        this.progressBar = progressBar;
    }

    protected StatusLine getStatusLine() {
        return this.statusLine;
    }

    protected JProgressBar getProgressBar() {
        return this.progressBar;
    }

    @Override
    public void beginSession(LoadEvent event) {
        super.beginSession(event);
        this.getStatusLine().showInfo("Searching for classes ...");
        this.getProgressBar().setValue(0);
        this.getProgressBar().setStringPainted(true);
    }

    @Override
    public void beginGroup(LoadEvent event) {
        super.beginGroup(event);
        this.getStatusLine().showInfo("Loading from " + event.getGroupName() + " ...");
    }

    @Override
    public void beginFile(LoadEvent event) {
        super.beginFile(event);
        if (event.getFilename().startsWith(event.getGroupName())) {
            this.getStatusLine().showInfo("Found " + event.getFilename() + " ...");
        } else {
            this.getStatusLine().showInfo("Found " + event.getGroupName() + " >> " + event.getFilename() + " ...");
        }
    }

    @Override
    public void endFile(LoadEvent event) {
        super.endFile(event);
        this.getProgressBar().setValue(this.getProgressBar().getValue() + 1);
    }

    @Override
    public void endSession(LoadEvent event) {
        super.endSession(event);
        this.getProgressBar().setValue(0);
        this.getProgressBar().setStringPainted(false);
    }
}

