/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.classreader.AggregatingClassfileLoader;
import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.ClassfileLoaderEventSource;
import com.jeantessier.classreader.ClassfileScanner;
import com.jeantessier.classreader.LoadListenerVisitorAdapter;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.dependencyfinder.gui.JavaBytecodeFileFilter;
import com.jeantessier.dependencyfinder.gui.MetricsVerboseListener;
import com.jeantessier.dependencyfinder.gui.OOMetrics;
import com.jeantessier.metrics.MetricsGatherer;
import com.jeantessier.metrics.TextPrinter;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

public class MetricsExtractAction
extends AbstractAction
implements Runnable {
    private OOMetrics model;
    private Collection<String> filenames;

    public MetricsExtractAction(OOMetrics model) {
        this.model = model;
        this.putValue("LongDescription", "Extract metrics from compiled classes");
        this.putValue("Name", "Extract");
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/extract.gif")));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser(this.model.getInputFile());
        chooser.addChoosableFileFilter(new JavaBytecodeFileFilter());
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(true);
        int returnValue = chooser.showDialog(this.model, "Extract");
        if (returnValue == 0) {
            File[] selectedFiles = chooser.getSelectedFiles();
            this.filenames = new LinkedList<String>();
            for (File file : selectedFiles) {
                this.filenames.add(file.toString());
            }
            this.model.setInputFile(selectedFiles[0]);
            new Thread(this).start();
        }
    }

    @Override
    public void run() {
        ClassfileLoaderEventSource loader;
        Date start = new Date();
        this.model.getStatusLine().showInfo("Scanning ...");
        ClassfileScanner scanner = new ClassfileScanner();
        scanner.load(this.filenames);
        this.model.getProgressBar().setMaximum(scanner.getNbFiles() + scanner.getNbClasses());
        MetricsVerboseListener verboseListener = new MetricsVerboseListener(this.model.getStatusLine(), this.model.getProgressBar());
        MetricsGatherer gatherer = new MetricsGatherer(this.model.getMetricsFactory());
        gatherer.addMetricsListener(verboseListener);
        if (this.model.isEnableCrossClassMeasurements()) {
            loader = new AggregatingClassfileLoader();
            ((ClassfileLoader)loader).addLoadListener(verboseListener);
            loader.load(this.filenames);
            gatherer.visitClassfiles(loader.getAllClassfiles());
        } else {
            loader = new TransientClassfileLoader();
            ((ClassfileLoader)loader).addLoadListener(verboseListener);
            ((ClassfileLoader)loader).addLoadListener(new LoadListenerVisitorAdapter(gatherer));
            loader.load(this.filenames);
        }
        this.model.getProgressBar().setIndeterminate(true);
        this.model.getStatusLine().showInfo("Generating method results ...");
        this.model.getMethodsModel().setMetrics(this.model.getMetricsFactory().getMethodMetrics());
        this.model.getStatusLine().showInfo("Generating class results ...");
        this.model.getClassesModel().setMetrics(this.model.getMetricsFactory().getClassMetrics());
        this.model.getStatusLine().showInfo("Generating group results ...");
        this.model.getGroupsModel().setMetrics(this.model.getMetricsFactory().getGroupMetrics());
        this.model.getStatusLine().showInfo("Generating project results ...");
        StringWriter out = new StringWriter();
        TextPrinter printer = new TextPrinter(new PrintWriter(out), this.model.getMetricsFactory().getConfiguration().getProjectMeasurements());
        printer.visitMetrics(this.model.getMetricsFactory().getProjectMetrics());
        this.model.getProjectArea().setText(out.toString());
        Date stop = new Date();
        this.model.getStatusLine().showInfo("Done (" + (double)(stop.getTime() - start.getTime()) / 1000.0 + " secs).");
        this.model.getProgressBar().setIndeterminate(false);
        this.model.setTitle("OO Metrics - Extractor");
    }
}

