/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.dependency.MatchException;
import com.jeantessier.dependencyfinder.gui.DependencyFinder;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class AllQueriesAction
extends AbstractAction
implements Runnable {
    private DependencyFinder model = null;

    public AllQueriesAction(DependencyFinder model) {
        this.model = model;
        this.putValue("LongDescription", "Compute graph, closure, and metrics");
        this.putValue("Name", "Compute All");
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/all-queries.gif")));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new Thread(this).start();
    }

    @Override
    public void run() {
        try {
            this.model.getStatusLine().showInfo("Processing all queries ...");
            Date start = new Date();
            this.model.clearDependencyResult();
            this.model.clearClosureResult();
            this.model.clearMetricsResult();
            this.model.getStatusLine().showInfo("Processing dependency query ...");
            this.model.doDependencyQuery();
            this.model.getStatusLine().showInfo("Processing closure query ...");
            this.model.doClosureQuery();
            this.model.getStatusLine().showInfo("Processing metrics query ...");
            this.model.doMetricsQuery();
            Date stop = new Date();
            this.model.getStatusLine().showInfo("Done (" + (double)(stop.getTime() - start.getTime()) / 1000.0 + " secs).");
        }
        catch (MatchException ex) {
            JOptionPane.showMessageDialog(this.model, ex.getMessage() + ": " + ex.getCause().getMessage(), "Malformed pattern", 0);
            this.model.getStatusLine().showInfo("Ready.");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.model, ex.getMessage(), "Error", 0);
            this.model.getStatusLine().showInfo("Ready.");
        }
    }
}

