/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.LoadListenerVisitorAdapter;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.dependency.CodeDependencyCollector;
import com.jeantessier.dependency.LinkMaximizer;
import com.jeantessier.dependency.LinkMinimizer;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.Printer;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.dependency.TextPrinter;
import com.jeantessier.dependency.XMLPrinter;
import com.jeantessier.dependencyfinder.cli.DirectoryExplorerCommand;
import java.util.Collection;

public class DependencyExtractor
extends DirectoryExplorerCommand {
    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.populateCommandLineSwitchesForXMLOutput("utf-8", "http://depfind.sourceforge.net/dtd", "    ");
        this.populateCommandLineSwitchesForFiltering();
        this.getCommandLine().addToggleSwitch("maximize");
        this.getCommandLine().addToggleSwitch("minimize");
        this.getCommandLine().addToggleSwitch("xml");
    }

    @Override
    protected Collection<CommandLineException> parseCommandLine(String[] args) {
        Collection<CommandLineException> exceptions = super.parseCommandLine(args);
        exceptions.addAll(this.validateCommandLineForFiltering());
        if (this.getCommandLine().getToggleSwitch("maximize") && this.getCommandLine().getToggleSwitch("minimize")) {
            exceptions.add(new CommandLineException("Only one of -maximize or -minimize is allowed"));
        }
        return exceptions;
    }

    @Override
    protected void doProcessing() throws Exception {
        SelectionCriteria filterCriteria = this.getFilterCriteria();
        NodeFactory factory = new NodeFactory();
        CodeDependencyCollector collector = new CodeDependencyCollector(factory, filterCriteria);
        TransientClassfileLoader loader = new TransientClassfileLoader();
        ((ClassfileLoader)loader).addLoadListener(new LoadListenerVisitorAdapter(collector));
        ((ClassfileLoader)loader).addLoadListener(this.getVerboseListener());
        loader.load(this.getCommandLine().getParameters());
        if (this.getCommandLine().getToggleSwitch("minimize")) {
            LinkMinimizer minimizer = new LinkMinimizer();
            minimizer.traverseNodes(factory.getPackages().values());
        } else if (this.getCommandLine().getToggleSwitch("maximize")) {
            LinkMaximizer maximizer = new LinkMaximizer();
            maximizer.traverseNodes(factory.getPackages().values());
        }
        this.getVerboseListener().print("Printing the graph ...");
        Printer printer = this.getCommandLine().getToggleSwitch("xml") ? new XMLPrinter(this.getOut(), this.getCommandLine().getSingleSwitch("encoding"), this.getCommandLine().getSingleSwitch("dtd-prefix")) : new TextPrinter(this.getOut());
        if (this.getCommandLine().isPresent("indent-text")) {
            printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
        }
        printer.traverseNodes(factory.getPackages().values());
    }

    public static void main(String[] args) throws Exception {
        new DependencyExtractor().run(args);
    }
}

