/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.dependency.CycleDetector;
import com.jeantessier.dependency.CyclePrinter;
import com.jeantessier.dependency.TextCyclePrinter;
import com.jeantessier.dependency.XMLCyclePrinter;
import com.jeantessier.dependencyfinder.cli.DependencyGraphCommand;
import java.util.Collection;

public class DependencyCycles
extends DependencyGraphCommand {
    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.populateCommandLineSwitchesForXMLOutput("utf-8", "http://depfind.sourceforge.net/dtd", "    ");
        this.populateCommandLineSwitchesForStartCondition();
        this.getCommandLine().addSingleValueSwitch("maximum-cycle-length");
        this.getCommandLine().addToggleSwitch("xml");
    }

    @Override
    protected Collection<CommandLineException> parseCommandLine(String[] args) {
        Collection<CommandLineException> exceptions = super.parseCommandLine(args);
        exceptions.addAll(this.validateCommandLineForScoping());
        return exceptions;
    }

    @Override
    protected void doProcessing() throws Exception {
        CycleDetector detector = new CycleDetector(this.getStartCriteria());
        if (this.getCommandLine().isPresent("maximum-cycle-length")) {
            detector.setMaximumCycleLength(Integer.parseInt(this.getCommandLine().getSingleSwitch("maximum-cycle-length")));
        }
        detector.traverseNodes(this.loadGraph().getPackages().values());
        this.getVerboseListener().print("Printing the graph ...");
        CyclePrinter printer = this.getCommandLine().isPresent("xml") ? new XMLCyclePrinter(this.getOut(), this.getCommandLine().getSingleSwitch("encoding"), this.getCommandLine().getSingleSwitch("dtd-prefix")) : new TextCyclePrinter(this.getOut());
        if (this.getCommandLine().isPresent("indent-text")) {
            printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
        }
        printer.visitCycles(detector.getCycles());
    }

    public static void main(String[] args) throws Exception {
        new DependencyCycles().run(args);
    }
}

