/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.classreader.LoadEvent;
import com.jeantessier.classreader.LoadListenerBase;
import com.jeantessier.text.MaximumCapacityPatternCache;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.oro.text.PatternCache;
import org.apache.oro.text.perl.Perl5Util;

public class ClassMatcher
extends LoadListenerBase {
    private Perl5Util perl = new Perl5Util((PatternCache)new MaximumCapacityPatternCache());
    private List<String> includes;
    private List<String> excludes;
    private Map<String, List<String>> results = new TreeMap<String, List<String>>();

    public ClassMatcher(List<String> includes, List<String> excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public Map<String, List<String>> getResults() {
        return this.results;
    }

    @Override
    public void endClassfile(LoadEvent event) {
        super.endClassfile(event);
        String className = event.getClassfile().getClassName();
        String groupName = event.getGroupName();
        if (this.matches(className)) {
            List<String> groups = this.results.get(className);
            if (groups == null) {
                groups = new LinkedList<String>();
                this.results.put(className, groups);
            }
            groups.add(groupName);
        }
    }

    private boolean matches(String name) {
        return this.matches(this.includes, name) && !this.matches(this.excludes, name);
    }

    private boolean matches(List<String> regularExpressions, String name) {
        boolean found = false;
        Iterator<String> i = regularExpressions.iterator();
        while (!found && i.hasNext()) {
            String condition = i.next();
            found = this.perl.match(condition, name);
        }
        return found;
    }
}

