/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.classreader.AggregatingClassfileLoader;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.dependencyfinder.cli.DiffCommand;
import com.jeantessier.diff.Differences;
import com.jeantessier.diff.Report;
import org.apache.log4j.Logger;

public class ClassClassDiff
extends DiffCommand {
    @Override
    public void doProcessing() throws Exception {
        AggregatingClassfileLoader oldJar = new AggregatingClassfileLoader();
        ((ClassfileLoader)oldJar).addLoadListener(this.getVerboseListener());
        oldJar.load(this.getCommandLine().getMultipleSwitch("old"));
        AggregatingClassfileLoader newJar = new AggregatingClassfileLoader();
        ((ClassfileLoader)newJar).addLoadListener(this.getVerboseListener());
        newJar.load(this.getCommandLine().getMultipleSwitch("new"));
        Logger.getLogger(this.getClass()).info((Object)"Comparing ...");
        this.getVerboseListener().print("Comparing ...");
        String name = this.getCommandLine().getSingleSwitch("name");
        String oldLabel = this.getCommandLine().getSingleSwitch("old-label");
        String newLabel = this.getCommandLine().getSingleSwitch("new-label");
        Classfile oldClass = ((ClassfileLoader)oldJar).getAllClassfiles().iterator().next();
        Classfile newClass = ((ClassfileLoader)newJar).getAllClassfiles().iterator().next();
        Differences differences = this.getDifferencesFactory().createClassDifferences(name, oldClass, newClass);
        Logger.getLogger(this.getClass()).info((Object)"Printing results ...");
        this.getVerboseListener().print("Printing results ...");
        Report report = new Report(this.getCommandLine().getSingleSwitch("encoding"), this.getCommandLine().getSingleSwitch("dtd-prefix"));
        if (this.getCommandLine().isPresent("indent-text")) {
            report.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
        }
        report.setName(name);
        report.setOldVersion(oldLabel);
        report.setNewVersion(newLabel);
        differences.accept(report);
        this.getOut().print(report.render());
    }

    public static void main(String[] args) throws Exception {
        new ClassClassDiff().run(args);
    }
}

