/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.ant;

import com.jeantessier.classreader.LoadEvent;
import com.jeantessier.dependency.DependencyEvent;
import com.jeantessier.dependency.DependencyListener;
import com.jeantessier.dependencyfinder.VerboseListenerBase;
import com.jeantessier.metrics.MetricsEvent;
import com.jeantessier.metrics.MetricsListener;
import org.apache.tools.ant.Task;

public class VerboseListener
extends VerboseListenerBase
implements DependencyListener,
MetricsListener {
    private Task task;

    public VerboseListener(Task task) {
        this.task = task;
    }

    @Override
    public void beginSession(LoadEvent event) {
        super.beginSession(event);
        this.task.log("Searching for classes ...", 3);
    }

    @Override
    public void beginGroup(LoadEvent event) {
        super.beginGroup(event);
        switch (this.getCurrentGroup().getSize()) {
            case -1: {
                this.task.log("Searching " + this.getCurrentGroup().getName() + " ...", 3);
                break;
            }
            case 0: 
            case 1: {
                this.task.log("Searching " + this.getCurrentGroup().getName() + " (" + this.getCurrentGroup().getSize() + " file) ...", 3);
                break;
            }
            default: {
                this.task.log("Searching " + this.getCurrentGroup().getName() + " (" + this.getCurrentGroup().getSize() + " files) ...", 3);
            }
        }
    }

    @Override
    public void endClassfile(LoadEvent event) {
        super.endClassfile(event);
        this.task.log("Loading " + event.getClassfile() + " ...", 3);
    }

    @Override
    public void endFile(LoadEvent event) {
        super.endFile(event);
        if (!this.getVisitedFiles().contains(event.getFilename())) {
            this.task.log("Skipping " + event.getFilename() + " ...", 3);
        }
    }

    @Override
    public void beginSession(DependencyEvent event) {
    }

    @Override
    public void beginClass(DependencyEvent event) {
        this.task.log("Getting dependencies from " + event.getClassName() + " ...", 3);
    }

    @Override
    public void dependency(DependencyEvent event) {
    }

    @Override
    public void endClass(DependencyEvent event) {
    }

    @Override
    public void endSession(DependencyEvent event) {
    }

    @Override
    public void beginSession(MetricsEvent event) {
    }

    @Override
    public void beginClass(MetricsEvent event) {
        this.task.log("Computing metrics for " + event.getClassfile() + " ...", 3);
    }

    @Override
    public void beginMethod(MetricsEvent event) {
    }

    @Override
    public void endMethod(MetricsEvent event) {
    }

    @Override
    public void endClass(MetricsEvent event) {
    }

    @Override
    public void endSession(MetricsEvent event) {
    }
}

