/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.ant;

import com.jeantessier.classreader.AggregatingClassfileLoader;
import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.ClassfileLoaderEventSource;
import com.jeantessier.classreader.LoadListenerVisitorAdapter;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.dependencyfinder.ant.VerboseListener;
import com.jeantessier.metrics.CSVPrinter;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.MetricsComparator;
import com.jeantessier.metrics.MetricsConfigurationLoader;
import com.jeantessier.metrics.MetricsFactory;
import com.jeantessier.metrics.MetricsGatherer;
import com.jeantessier.metrics.TextPrinter;
import com.jeantessier.metrics.XMLPrinter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.xml.sax.SAXException;

public class OOMetrics
extends Task {
    public static final String DEFAULT_PROJECT_NAME = "Project";
    public static final String DEFAULT_SORT = "name";
    private String projectName = "Project";
    private File configuration;
    private boolean csv = false;
    private boolean txt = false;
    private boolean xml = false;
    private boolean validate = false;
    private String encoding = "utf-8";
    private String dtdPrefix = "http://depfind.sourceforge.net/dtd";
    private String indentText;
    private boolean projectMetrics = false;
    private boolean groupMetrics = false;
    private boolean classMetrics = false;
    private boolean methodMetrics = false;
    private Path scopeIncludesList;
    private Path scopeExcludesList;
    private Path filterIncludesList;
    private Path filterExcludesList;
    private boolean showAllMetrics = false;
    private boolean showEmptyMetrics = false;
    private boolean showHiddenMeasurements = false;
    private String sort = "name";
    private boolean expand = false;
    private boolean reverse = false;
    private boolean enableCrossClassMeasurements = false;
    private File destprefix;
    private Path path;

    public String getProjectname() {
        return this.projectName;
    }

    public void setProjectname(String projectName) {
        this.projectName = projectName;
    }

    public File getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(File configuration) {
        this.configuration = configuration;
    }

    public boolean getCsv() {
        return this.csv;
    }

    public void setCsv(boolean csv) {
        this.csv = csv;
    }

    public boolean getTxt() {
        return this.txt;
    }

    public void setTxt(boolean txt) {
        this.txt = txt;
    }

    public boolean getXml() {
        return this.xml;
    }

    public void setXml(boolean xml) {
        this.xml = xml;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDtdprefix() {
        return this.dtdPrefix;
    }

    public void setDtdprefix(String dtdPrefix) {
        this.dtdPrefix = dtdPrefix;
    }

    public String getIndenttext() {
        return this.indentText;
    }

    public void setIntenttext(String indentText) {
        this.indentText = indentText;
    }

    public boolean getProjectmetrics() {
        return this.projectMetrics;
    }

    public void setProjectmetrics(boolean projectMetrics) {
        this.projectMetrics = projectMetrics;
    }

    public boolean getGroupmetrics() {
        return this.groupMetrics;
    }

    public void setGroupmetrics(boolean groupMetrics) {
        this.groupMetrics = groupMetrics;
    }

    public boolean getClassmetrics() {
        return this.classMetrics;
    }

    public void setClassmetrics(boolean classMetrics) {
        this.classMetrics = classMetrics;
    }

    public boolean getMethodmetrics() {
        return this.methodMetrics;
    }

    public void setMethodmetrics(boolean methodMetrics) {
        this.methodMetrics = methodMetrics;
    }

    public void setAllmetrics(boolean allMetrics) {
        this.setProjectmetrics(allMetrics);
        this.setGroupmetrics(allMetrics);
        this.setClassmetrics(allMetrics);
        this.setMethodmetrics(allMetrics);
    }

    public Path createScopeincludeslist() {
        if (this.scopeIncludesList == null) {
            this.scopeIncludesList = new Path(this.getProject());
        }
        return this.scopeIncludesList;
    }

    public Path getScopeincludeslist() {
        return this.scopeIncludesList;
    }

    public Path createScopeexcludeslist() {
        if (this.scopeExcludesList == null) {
            this.scopeExcludesList = new Path(this.getProject());
        }
        return this.scopeExcludesList;
    }

    public Path getScopeexcludeslist() {
        return this.scopeExcludesList;
    }

    public Path createFilterincludeslist() {
        if (this.filterIncludesList == null) {
            this.filterIncludesList = new Path(this.getProject());
        }
        return this.filterIncludesList;
    }

    public Path getFilterincludeslist() {
        return this.filterIncludesList;
    }

    public Path createFilterexcludeslist() {
        if (this.filterExcludesList == null) {
            this.filterExcludesList = new Path(this.getProject());
        }
        return this.filterExcludesList;
    }

    public Path getFilterexcludeslist() {
        return this.filterExcludesList;
    }

    public boolean getShowallmetrics() {
        return this.showAllMetrics;
    }

    public void setShowallmetrics(boolean showAllMetrics) {
        this.showAllMetrics = showAllMetrics;
    }

    public boolean getShowemptymetrics() {
        return this.showEmptyMetrics;
    }

    public void setShowemptymetrics(boolean showEmptyMetrics) {
        this.showEmptyMetrics = showEmptyMetrics;
    }

    public boolean getShowhiddenmeasurements() {
        return this.showHiddenMeasurements;
    }

    public void setShowhiddenmeasurements(boolean showHiddenMeasurements) {
        this.showHiddenMeasurements = showHiddenMeasurements;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public boolean getExpand() {
        return this.expand;
    }

    public void setExpand(boolean expand) {
        this.expand = expand;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public boolean getEnablecrossclassmeasurements() {
        return this.enableCrossClassMeasurements;
    }

    public void setEnablecrossclassmeasurements(boolean enableCrossClassMeasurements) {
        this.enableCrossClassMeasurements = enableCrossClassMeasurements;
    }

    public File getDestprefix() {
        return this.destprefix;
    }

    public void setDestprefix(File destprefix) {
        this.destprefix = destprefix;
    }

    public Path createPath() {
        if (this.path == null) {
            this.path = new Path(this.getProject());
        }
        return this.path;
    }

    public Path getPath() {
        return this.path;
    }

    public void execute() throws BuildException {
        if (this.getConfiguration() == null) {
            throw new BuildException("configuration must be set!");
        }
        if (!this.getConfiguration().exists()) {
            throw new BuildException("configuration does not exist!");
        }
        if (!this.getConfiguration().isFile()) {
            throw new BuildException("configuration is not a file!");
        }
        if (this.getPath() == null) {
            throw new BuildException("path must be set!");
        }
        if (this.getDestprefix() == null) {
            throw new BuildException("destprefix must be set!");
        }
        try {
            ClassfileLoaderEventSource loader;
            VerboseListener verboseListener = new VerboseListener(this);
            this.log("Reading configuration ...");
            MetricsFactory factory = new MetricsFactory(this.getProjectname(), new MetricsConfigurationLoader(this.getValidate()).load(this.getConfiguration().getAbsolutePath()));
            MetricsGatherer gatherer = new MetricsGatherer(factory);
            if (this.getScopeincludeslist() != null || this.getScopeexcludeslist() != null) {
                gatherer.setScopeIncludes(this.createCollection(this.getScopeincludeslist(), this.getScopeexcludeslist()));
            }
            if (this.getFilterincludeslist() != null || this.getFilterexcludeslist() != null) {
                gatherer.setFilterIncludes(this.createCollection(this.getFilterincludeslist(), this.getFilterexcludeslist()));
            }
            gatherer.addMetricsListener(verboseListener);
            if (this.getEnablecrossclassmeasurements()) {
                this.log("Reading in all classes from path " + this.getPath());
                loader = new AggregatingClassfileLoader();
                ((ClassfileLoader)loader).addLoadListener(verboseListener);
                loader.load(Arrays.asList(this.getPath().list()));
                this.log("Computing metrics ...");
                gatherer.visitClassfiles(loader.getAllClassfiles());
            } else {
                loader = new TransientClassfileLoader();
                ((ClassfileLoader)loader).addLoadListener(verboseListener);
                ((ClassfileLoader)loader).addLoadListener(new LoadListenerVisitorAdapter(gatherer));
                this.log("Reading classes and computing metrics as we go ...");
                loader.load(Arrays.asList(this.getPath().list()));
            }
            if (this.getShowallmetrics()) {
                for (Metrics metrics : gatherer.getMetricsFactory().getAllClassMetrics()) {
                    gatherer.getMetricsFactory().includeClassMetrics(metrics);
                }
                for (Metrics metrics : gatherer.getMetricsFactory().getAllMethodMetrics()) {
                    gatherer.getMetricsFactory().includeMethodMetrics(metrics);
                }
            }
            if (this.getCsv()) {
                this.printCSVFiles(gatherer.getMetricsFactory());
            } else if (this.getTxt()) {
                this.printTextFile(gatherer.getMetricsFactory());
            } else if (this.getXml()) {
                this.printXMLFile(gatherer.getMetricsFactory());
            }
        }
        catch (SAXException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private Collection<String> createCollection(Path includes, Path excludes) throws IOException {
        String line;
        BufferedReader reader;
        String[] filenames;
        HashSet<String> result = new HashSet<String>();
        if (includes != null) {
            for (String filename : filenames = includes.list()) {
                reader = new BufferedReader(new FileReader(filename));
                while ((line = reader.readLine()) != null) {
                    result.add(line);
                }
                reader.close();
            }
        }
        if (excludes != null) {
            for (String filename : filenames = excludes.list()) {
                reader = new BufferedReader(new FileReader(filename));
                while ((line = reader.readLine()) != null) {
                    result.remove(line);
                }
                reader.close();
            }
        }
        return result;
    }

    private void printCSVFiles(MetricsFactory factory) throws IOException {
        CSVPrinter printer;
        ArrayList<Metrics> metrics;
        PrintWriter out;
        String filename;
        MetricsComparator comparator = new MetricsComparator(this.getSort());
        if (this.getReverse()) {
            comparator.reverse();
        }
        if (this.getProjectmetrics()) {
            filename = this.getDestprefix().getAbsolutePath() + "_project.csv";
            this.log("Saving metrics to " + filename);
            out = new PrintWriter(new FileWriter(filename));
            metrics = new ArrayList<Metrics>(factory.getProjectMetrics());
            Collections.sort(metrics, comparator);
            printer = new CSVPrinter(out, factory.getConfiguration().getProjectMeasurements());
            printer.setShowEmptyMetrics(this.getShowemptymetrics());
            printer.setShowHiddenMeasurements(this.getShowhiddenmeasurements());
            if (this.getIndenttext() != null) {
                printer.setIndentText(this.getIndenttext());
            }
            printer.visitMetrics(metrics);
            out.close();
        }
        if (this.getGroupmetrics()) {
            filename = this.getDestprefix().getAbsolutePath() + "_groups.csv";
            this.log("Saving metrics to " + filename);
            out = new PrintWriter(new FileWriter(filename));
            metrics = new ArrayList<Metrics>(factory.getGroupMetrics());
            Collections.sort(metrics, comparator);
            printer = new CSVPrinter(out, factory.getConfiguration().getGroupMeasurements());
            printer.setShowEmptyMetrics(this.getShowemptymetrics());
            printer.setShowHiddenMeasurements(this.getShowhiddenmeasurements());
            if (this.getIndenttext() != null) {
                printer.setIndentText(this.getIndenttext());
            }
            printer.visitMetrics(metrics);
            out.close();
        }
        if (this.getClassmetrics()) {
            filename = this.getDestprefix().getAbsolutePath() + "_classes.csv";
            this.log("Saving metrics to " + filename);
            out = new PrintWriter(new FileWriter(filename));
            metrics = new ArrayList<Metrics>(factory.getClassMetrics());
            Collections.sort(metrics, comparator);
            printer = new CSVPrinter(out, factory.getConfiguration().getClassMeasurements());
            printer.setShowEmptyMetrics(this.getShowemptymetrics());
            printer.setShowHiddenMeasurements(this.getShowhiddenmeasurements());
            if (this.getIndenttext() != null) {
                printer.setIndentText(this.getIndenttext());
            }
            printer.visitMetrics(metrics);
            out.close();
        }
        if (this.getMethodmetrics()) {
            filename = this.getDestprefix().getAbsolutePath() + "_methods.csv";
            this.log("Saving metrics to " + filename);
            out = new PrintWriter(new FileWriter(filename));
            metrics = new ArrayList<Metrics>(factory.getMethodMetrics());
            Collections.sort(metrics, comparator);
            printer = new CSVPrinter(out, factory.getConfiguration().getMethodMeasurements());
            printer.setShowEmptyMetrics(this.getShowemptymetrics());
            printer.setShowHiddenMeasurements(this.getShowhiddenmeasurements());
            if (this.getIndenttext() != null) {
                printer.setIndentText(this.getIndenttext());
            }
            printer.visitMetrics(metrics);
            out.close();
        }
    }

    private void printTextFile(MetricsFactory factory) throws IOException {
        TextPrinter printer;
        ArrayList<Metrics> metrics;
        MetricsComparator comparator = new MetricsComparator(this.getSort());
        if (this.getReverse()) {
            comparator.reverse();
        }
        String filename = this.getDestprefix().getAbsolutePath() + ".txt";
        this.log("Saving metrics to " + filename);
        PrintWriter out = new PrintWriter(new FileWriter(filename));
        if (this.getProjectmetrics()) {
            out.println("Project metrics");
            out.println("---------------");
            metrics = new ArrayList<Metrics>(factory.getProjectMetrics());
            Collections.sort(metrics, comparator);
            printer = new TextPrinter(out, factory.getConfiguration().getProjectMeasurements());
            printer.setShowEmptyMetrics(this.getShowemptymetrics());
            printer.setShowHiddenMeasurements(this.getShowhiddenmeasurements());
            printer.setExpandCollectionMeasurements(this.getExpand());
            if (this.getIndenttext() != null) {
                printer.setIndentText(this.getIndenttext());
            }
            printer.visitMetrics(metrics);
            out.println();
        }
        if (this.getGroupmetrics()) {
            out.println("Group metrics");
            out.println("-------------");
            metrics = new ArrayList<Metrics>(factory.getGroupMetrics());
            Collections.sort(metrics, comparator);
            printer = new TextPrinter(out, factory.getConfiguration().getGroupMeasurements());
            printer.setShowEmptyMetrics(this.getShowemptymetrics());
            printer.setShowHiddenMeasurements(this.getShowhiddenmeasurements());
            printer.setExpandCollectionMeasurements(this.getExpand());
            if (this.getIndenttext() != null) {
                printer.setIndentText(this.getIndenttext());
            }
            printer.visitMetrics(metrics);
            out.println();
        }
        if (this.getClassmetrics()) {
            out.println("Class metrics");
            out.println("-------------");
            metrics = new ArrayList<Metrics>(factory.getClassMetrics());
            Collections.sort(metrics, comparator);
            printer = new TextPrinter(out, factory.getConfiguration().getClassMeasurements());
            printer.setShowEmptyMetrics(this.getShowemptymetrics());
            printer.setShowHiddenMeasurements(this.getShowhiddenmeasurements());
            printer.setExpandCollectionMeasurements(this.getExpand());
            if (this.getIndenttext() != null) {
                printer.setIndentText(this.getIndenttext());
            }
            printer.visitMetrics(metrics);
            out.println();
        }
        if (this.getMethodmetrics()) {
            out.println("Method metrics");
            out.println("--------------");
            metrics = new ArrayList<Metrics>(factory.getMethodMetrics());
            Collections.sort(metrics, comparator);
            printer = new TextPrinter(out, factory.getConfiguration().getMethodMeasurements());
            printer.setShowEmptyMetrics(this.getShowemptymetrics());
            printer.setShowHiddenMeasurements(this.getShowhiddenmeasurements());
            printer.setExpandCollectionMeasurements(this.getExpand());
            if (this.getIndenttext() != null) {
                printer.setIndentText(this.getIndenttext());
            }
            printer.visitMetrics(metrics);
            out.println();
        }
        out.close();
    }

    private void printXMLFile(MetricsFactory factory) throws IOException {
        MetricsComparator comparator = new MetricsComparator(this.getSort());
        if (this.getReverse()) {
            comparator.reverse();
        }
        String filename = this.getDestprefix().getAbsolutePath() + ".xml";
        this.log("Saving metrics to " + filename);
        PrintWriter out = new PrintWriter(new FileWriter(filename));
        ArrayList<Metrics> metrics = new ArrayList<Metrics>(factory.getProjectMetrics());
        Collections.sort(metrics, comparator);
        XMLPrinter printer = new XMLPrinter(out, factory.getConfiguration(), this.getEncoding(), this.getDtdprefix());
        printer.setShowEmptyMetrics(this.getShowemptymetrics());
        printer.setShowHiddenMeasurements(this.getShowhiddenmeasurements());
        if (this.getIndenttext() != null) {
            printer.setIndentText(this.getIndenttext());
        }
        printer.visitMetrics(metrics);
        out.close();
    }
}

