/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.ant;

import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.NodeLoader;
import com.jeantessier.dependency.Printer;
import com.jeantessier.dependency.RegularExpressionSelectionCriteria;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.dependency.TextPrinter;
import com.jeantessier.dependency.TransitiveClosure;
import com.jeantessier.dependency.XMLPrinter;
import com.jeantessier.dependencyfinder.ant.GraphTask;
import com.jeantessier.dependencyfinder.ant.VerboseListener;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.xml.sax.SAXException;

public class DependencyClosure
extends GraphTask {
    private String startIncludes = "//";
    private String startExcludes = "";
    private String packageStartIncludes = "";
    private String packageStartExcludes = "";
    private String classStartIncludes = "";
    private String classStartExcludes = "";
    private String featureStartIncludes = "";
    private String featureStartExcludes = "";
    private String stopIncludes = "";
    private String stopExcludes = "";
    private String packageStopIncludes = "";
    private String packageStopExcludes = "";
    private String classStopIncludes = "";
    private String classStopExcludes = "";
    private String featureStopIncludes = "";
    private String featureStopExcludes = "";
    private String maximumInboundDepth = "";
    private String maximumOutboundDepth = "";
    private boolean xml = false;
    private String encoding = "utf-8";
    private String dtdPrefix = "http://depfind.sourceforge.net/dtd";
    private String indentText;

    public String getStartincludes() {
        return this.startIncludes;
    }

    public void setStartincludes(String startIncludes) {
        this.startIncludes = startIncludes;
    }

    public String getStartexcludes() {
        return this.startExcludes;
    }

    public void setStartexcludes(String startExcludes) {
        this.startExcludes = startExcludes;
    }

    public String getPackagestartincludes() {
        return this.packageStartIncludes;
    }

    public void setPackagestartincludes(String packageStartIncludes) {
        this.packageStartIncludes = packageStartIncludes;
    }

    public String getPackagestartexcludes() {
        return this.packageStartExcludes;
    }

    public void setPackagestartexcludes(String packageStartExcludes) {
        this.packageStartExcludes = packageStartExcludes;
    }

    public String getClassstartincludes() {
        return this.classStartIncludes;
    }

    public void setClassstartincludes(String classStartIncludes) {
        this.classStartIncludes = classStartIncludes;
    }

    public String getClassstartexcludes() {
        return this.classStartExcludes;
    }

    public void setClassstartexcludes(String classStartExcludes) {
        this.classStartExcludes = classStartExcludes;
    }

    public String getFeaturestartincludes() {
        return this.featureStartIncludes;
    }

    public void setFeaturestartincludes(String featureStartIncludes) {
        this.featureStartIncludes = featureStartIncludes;
    }

    public String getFeaturestartexcludes() {
        return this.featureStartExcludes;
    }

    public void setFeaturestartexcludes(String featureStartExcludes) {
        this.featureStartExcludes = featureStartExcludes;
    }

    public String getStopincludes() {
        return this.stopIncludes;
    }

    public void setStopincludes(String stopIncludes) {
        this.stopIncludes = stopIncludes;
    }

    public String getStopexcludes() {
        return this.stopExcludes;
    }

    public void setStopexcludes(String stopExcludes) {
        this.stopExcludes = stopExcludes;
    }

    public String getPackagestopincludes() {
        return this.packageStopIncludes;
    }

    public void setPackagestopincludes(String packageStopIncludes) {
        this.packageStopIncludes = packageStopIncludes;
    }

    public String getPackagestopexcludes() {
        return this.packageStopExcludes;
    }

    public void setPackagestopexcludes(String packageStopExcludes) {
        this.packageStopExcludes = packageStopExcludes;
    }

    public String getClassstopincludes() {
        return this.classStopIncludes;
    }

    public void setClassstopincludes(String classStopIncludes) {
        this.classStopIncludes = classStopIncludes;
    }

    public String getClassstopexcludes() {
        return this.classStopExcludes;
    }

    public void setClassstopexcludes(String classStopExcludes) {
        this.classStopExcludes = classStopExcludes;
    }

    public String getFeaturestopincludes() {
        return this.featureStopIncludes;
    }

    public void setFeaturestopincludes(String featureStopIncludes) {
        this.featureStopIncludes = featureStopIncludes;
    }

    public String getFeaturestopexcludes() {
        return this.featureStopExcludes;
    }

    public void setFeaturestopexcludes(String featureStopExcludes) {
        this.featureStopExcludes = featureStopExcludes;
    }

    public String getMaximuminbounddepth() {
        return this.maximumInboundDepth;
    }

    public void setMaximuminbounddepth(String maximumInboundDepth) {
        this.maximumInboundDepth = maximumInboundDepth;
    }

    public String getMaximumoutbounddepth() {
        return this.maximumOutboundDepth;
    }

    public void setMaximumoutbounddepth(String maximumOutboundDepth) {
        this.maximumOutboundDepth = maximumOutboundDepth;
    }

    public boolean getXml() {
        return this.xml;
    }

    public void setXml(boolean xml) {
        this.xml = xml;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDtdprefix() {
        return this.dtdPrefix;
    }

    public void setDtdprefix(String dtdPrefix) {
        this.dtdPrefix = dtdPrefix;
    }

    public String getIndenttext() {
        return this.indentText;
    }

    public void setIntenttext(String indentText) {
        this.indentText = indentText;
    }

    public void execute() throws BuildException {
        this.validateParameters();
        VerboseListener verboseListener = new VerboseListener(this);
        try {
            NodeFactory factory = new NodeFactory();
            for (String filename : this.getSrc().list()) {
                this.log("Reading graph from " + filename);
                if (!filename.endsWith(".xml")) continue;
                NodeLoader loader = new NodeLoader(factory, this.getValidate());
                loader.addDependencyListener(verboseListener);
                loader.load(filename);
            }
            TransitiveClosure selector = new TransitiveClosure(this.getStartCriteria(), this.getStopCriteria());
            try {
                if (this.getMaximuminbounddepth() != null) {
                    selector.setMaximumInboundDepth(Long.parseLong(this.getMaximuminbounddepth()));
                }
            }
            catch (NumberFormatException ex) {
                selector.setMaximumInboundDepth(Long.MAX_VALUE);
            }
            try {
                if (this.getMaximumoutbounddepth() != null) {
                    selector.setMaximumOutboundDepth(Long.parseLong(this.getMaximumoutbounddepth()));
                }
            }
            catch (NumberFormatException ex) {
                selector.setMaximumOutboundDepth(Long.MAX_VALUE);
            }
            selector.traverseNodes(factory.getPackages().values());
            this.log("Saving dependency graph to " + this.getDestfile().getAbsolutePath());
            PrintWriter out = new PrintWriter(new FileWriter(this.getDestfile()));
            Printer printer = this.getXml() ? new XMLPrinter(out, this.getEncoding(), this.getDtdprefix()) : new TextPrinter(out);
            if (this.getIndenttext() != null) {
                printer.setIndentText(this.getIndenttext());
            }
            printer.traverseNodes(selector.getFactory().getPackages().values());
            out.close();
        }
        catch (SAXException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private SelectionCriteria getStartCriteria() throws BuildException {
        RegularExpressionSelectionCriteria result = new RegularExpressionSelectionCriteria();
        result.setGlobalIncludes(this.getStartincludes());
        result.setGlobalExcludes(this.getStartexcludes());
        result.setPackageIncludes(this.getPackagestartincludes());
        result.setPackageExcludes(this.getPackagestartexcludes());
        result.setClassIncludes(this.getClassstartincludes());
        result.setClassExcludes(this.getClassstartexcludes());
        result.setFeatureIncludes(this.getFeaturestartincludes());
        result.setFeatureExcludes(this.getFeaturestartexcludes());
        return result;
    }

    private SelectionCriteria getStopCriteria() throws BuildException {
        RegularExpressionSelectionCriteria result = new RegularExpressionSelectionCriteria();
        result.setGlobalIncludes(this.getStopincludes());
        result.setGlobalExcludes(this.getStopexcludes());
        result.setPackageIncludes(this.getPackagestopincludes());
        result.setPackageExcludes(this.getPackagestopexcludes());
        result.setClassIncludes(this.getClassstopincludes());
        result.setClassExcludes(this.getClassstopexcludes());
        result.setFeatureIncludes(this.getFeaturestopincludes());
        result.setFeatureExcludes(this.getFeaturestopexcludes());
        return result;
    }
}

