/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.Cycle;
import com.jeantessier.dependency.CyclePrinter;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.Visitor;
import java.io.PrintWriter;
import java.util.Collection;

public class XMLCyclePrinter
implements CyclePrinter,
Visitor {
    public static final String DEFAULT_ENCODING = "utf-8";
    public static final String DEFAULT_DTD_PREFIX = "http://depfind.sourceforge.net/dtd";
    private PrintWriter out;
    private String indentText = "    ";

    public XMLCyclePrinter(PrintWriter out) {
        this(out, DEFAULT_ENCODING, DEFAULT_DTD_PREFIX);
    }

    public XMLCyclePrinter(PrintWriter out, String encoding, String dtdPrefix) {
        this.out = out;
        this.appendHeader(encoding, dtdPrefix);
    }

    private void appendHeader(String encoding, String dtdPrefix) {
        this.out.append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\" ?>").println();
        this.out.println();
        this.out.append("<!DOCTYPE dependencies SYSTEM \"").append(dtdPrefix).append("/cycles.dtd\">").println();
        this.out.println();
    }

    @Override
    public void setIndentText(String indentText) {
        this.indentText = indentText;
    }

    @Override
    public void visitCycles(Collection<Cycle> cycles) {
        this.out.append("<cycles>").println();
        for (Cycle cycle : cycles) {
            this.visitCycle(cycle);
        }
        this.out.append("</cycles>").println();
    }

    @Override
    public void visitCycle(Cycle cycle) {
        this.out.append(this.indentText).append("<cycle>").println();
        this.traverseNodes(cycle.getPath());
        this.out.append(this.indentText).append("</cycle>").println();
    }

    @Override
    public void traverseNodes(Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            node.accept(this);
        }
    }

    @Override
    public void traverseInbound(Collection<? extends Node> nodes) {
        throw new UnsupportedOperationException("not implemented yet.");
    }

    @Override
    public void traverseOutbound(Collection<? extends Node> nodes) {
        throw new UnsupportedOperationException("not implemented yet.");
    }

    @Override
    public void visitPackageNode(PackageNode node) {
        this.visitNode(node, "package");
    }

    @Override
    public void visitInboundPackageNode(PackageNode node) {
    }

    @Override
    public void visitOutboundPackageNode(PackageNode node) {
    }

    @Override
    public void visitClassNode(ClassNode node) {
        this.visitNode(node, "class");
    }

    @Override
    public void visitInboundClassNode(ClassNode node) {
    }

    @Override
    public void visitOutboundClassNode(ClassNode node) {
    }

    @Override
    public void visitFeatureNode(FeatureNode node) {
        this.visitNode(node, "feature");
    }

    @Override
    public void visitInboundFeatureNode(FeatureNode node) {
    }

    @Override
    public void visitOutboundFeatureNode(FeatureNode node) {
    }

    private void visitNode(Node node, String type) {
        this.out.append(this.indentText).append(this.indentText).append("<node type=\"").append(type).append("\">").append(node.getName()).append("</node>").println();
    }
}

