/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClosureLayerSelector;
import com.jeantessier.dependency.ClosureSelector;
import com.jeantessier.dependency.ClosureStartSelector;
import com.jeantessier.dependency.ClosureStopSelector;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.SelectionCriteria;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;

public class TransitiveClosureEngine {
    private NodeFactory factory;
    private ClosureLayerSelector layerSelector;
    private ClosureStopSelector stopSelector;
    private Collection<Node> coverage = new HashSet<Node>();
    private LinkedList<Collection<? extends Node>> selections = new LinkedList();
    private LinkedList<Collection<? extends Node>> layers = new LinkedList();

    public TransitiveClosureEngine(Collection<? extends Node> packages, SelectionCriteria startCriteria, SelectionCriteria stopCriteria, ClosureLayerSelector layerSelector) {
        this(new NodeFactory(), packages, startCriteria, stopCriteria, layerSelector);
    }

    public TransitiveClosureEngine(NodeFactory factory, Collection<? extends Node> packages, SelectionCriteria startCriteria, SelectionCriteria stopCriteria, ClosureLayerSelector layerSelector) {
        this.factory = factory;
        this.layerSelector = layerSelector;
        this.layerSelector.setFactory(factory);
        this.layerSelector.setCoverage(this.coverage);
        this.stopSelector = new ClosureStopSelector(stopCriteria);
        this.init(packages, startCriteria);
    }

    private void init(Collection<? extends Node> packages, SelectionCriteria startCriteria) {
        ClosureStartSelector startSelector = new ClosureStartSelector(this.factory, startCriteria);
        startSelector.traverseNodes(packages);
        this.stopSelector.traverseNodes(startSelector.getCopiedNodes());
        this.gatherResults(startSelector);
    }

    public NodeFactory getFactory() {
        return this.factory;
    }

    public int getNbLayers() {
        return this.layers.size();
    }

    public Collection getLayer(int i) {
        return this.layers.get(i);
    }

    public void computeAllLayers() {
        while (!this.stopSelector.isDone()) {
            this.computeNextLayer();
        }
    }

    public void computeLayers(long nbLayers) {
        for (long i = 0L; !this.stopSelector.isDone() && i < nbLayers; ++i) {
            this.computeNextLayer();
        }
    }

    public void computeNextLayer() {
        if (!this.stopSelector.isDone()) {
            this.layerSelector.reset();
            this.layerSelector.traverseNodes(this.selections.getLast());
            this.stopSelector.traverseNodes(this.layerSelector.getCopiedNodes());
            if (!this.layerSelector.getCopiedNodes().isEmpty()) {
                this.gatherResults(this.layerSelector);
            }
        }
    }

    private void gatherResults(ClosureSelector selector) {
        this.coverage.addAll(selector.getSelectedNodes());
        this.selections.add(selector.getSelectedNodes());
        this.layers.add(selector.getCopiedNodes());
    }
}

