/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.DependencyListener;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.NodeHandler;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class NodeLoader {
    private static final boolean DEFAULT_VALIDATE = false;
    private NodeHandler handler;
    private boolean validate;

    public NodeLoader() {
        this(new NodeFactory(), false);
    }

    public NodeLoader(NodeFactory factory) {
        this(factory, false);
    }

    public NodeLoader(boolean validate) {
        this(new NodeFactory(), validate);
    }

    public NodeLoader(NodeFactory factory, boolean validate) {
        this.handler = new NodeHandler(factory);
        this.validate = validate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeFactory load(String filename) throws IOException, SAXException, ParserConfigurationException {
        NodeFactory result = null;
        FileReader in = null;
        try {
            in = new FileReader(filename);
            result = this.load(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return result;
    }

    public NodeFactory load(InputStream in) throws IOException, ParserConfigurationException, SAXException {
        return this.load(new InputSource(in));
    }

    public NodeFactory load(Reader in) throws IOException, ParserConfigurationException, SAXException {
        return this.load(new InputSource(in));
    }

    public NodeFactory load(InputSource in) throws IOException, ParserConfigurationException, SAXException {
        XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        reader.setDTDHandler(this.handler);
        reader.setContentHandler(this.handler);
        reader.setErrorHandler(this.handler);
        try {
            if (this.validate) {
                Logger.getLogger(this.getClass()).warn((Object)"XML validation turned on");
                reader.setFeature("http://xml.org/sax/features/validation", true);
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
            } else {
                Logger.getLogger(this.getClass()).info((Object)"XML validation turned off");
                reader.setFeature("http://xml.org/sax/features/validation", false);
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass()).warn((Object)"Problem setting validation feature on XML reader", (Throwable)ex);
        }
        reader.parse(in);
        return this.handler.getFactory();
    }

    public void addDependencyListener(DependencyListener listener) {
        this.handler.addDependencyListener(listener);
    }

    public void removeDependencyListener(DependencyListener listener) {
        this.handler.removeDependencyListener(listener);
    }
}

