/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.TraversalStrategy;
import com.jeantessier.dependency.VisitorBase;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class MetricsGatherer
extends VisitorBase {
    private Collection<PackageNode> packages = new LinkedList<PackageNode>();
    private Collection<ClassNode> classes = new LinkedList<ClassNode>();
    private Collection<FeatureNode> features = new LinkedList<FeatureNode>();
    private long nbOutbound = 0L;
    private long nbInbound = 0L;
    private long nbOutboundPackages = 0L;
    private long nbInboundPackages = 0L;
    private long nbOutboundClasses = 0L;
    private long nbInboundClasses = 0L;
    private long nbOutboundFeatures = 0L;
    private long nbInboundFeatures = 0L;
    private Map<Integer, long[]> chartData = new TreeMap<Integer, long[]>();
    private int chartMaximum = 0;
    public static final int CHART_INDEX = 0;
    public static final int CLASSES_PER_PACKAGE = 1;
    public static final int FEATURES_PER_CLASS = 2;
    public static final int INBOUNDS_PER_PACKAGE = 3;
    public static final int OUTBOUNDS_PER_PACKAGE = 4;
    public static final int INBOUNDS_PER_CLASS = 5;
    public static final int OUTBOUNDS_PER_CLASS = 6;
    public static final int INBOUNDS_PER_FEATURE = 7;
    public static final int OUTBOUNDS_PER_FEATURE = 8;
    public static final int NB_CHARTS = 9;
    private static final String[] CHART_NAMES = new String[]{"n", "Classes per Package", "Feafures per Class", "Inbounds per Package", "Outbounds per Package", "Inbounds per Class", "Outbounds per Class", "Inbounds per Feature", "Outbounds per Feature"};

    public static int getNbCharts() {
        return 9;
    }

    public static String getChartName(int i) {
        return CHART_NAMES[i];
    }

    public MetricsGatherer() {
    }

    public MetricsGatherer(TraversalStrategy strategy) {
        super(strategy);
    }

    public long[] getChartData(int i) {
        long[] result = this.chartData.get(i);
        if (result == null) {
            result = new long[9];
            result[0] = i;
            this.chartData.put(i, result);
            if (this.chartMaximum < i) {
                this.chartMaximum = i;
            }
        }
        return result;
    }

    public int getChartMaximum() {
        return this.chartMaximum;
    }

    public Collection<PackageNode> getPackages() {
        return this.packages;
    }

    public Collection<ClassNode> getClasses() {
        return this.classes;
    }

    public Collection<FeatureNode> getFeatures() {
        return this.features;
    }

    public long getNbOutbound() {
        return this.nbOutbound;
    }

    public long getNbInbound() {
        return this.nbInbound;
    }

    public long getNbOutboundPackages() {
        return this.nbOutboundPackages;
    }

    public long getNbInboundPackages() {
        return this.nbInboundPackages;
    }

    public long getNbOutboundClasses() {
        return this.nbOutboundClasses;
    }

    public long getNbInboundClasses() {
        return this.nbInboundClasses;
    }

    public long getNbOutboundFeatures() {
        return this.nbOutboundFeatures;
    }

    public long getNbInboundFeatures() {
        return this.nbInboundFeatures;
    }

    @Override
    public void preprocessPackageNode(PackageNode node) {
        super.preprocessPackageNode(node);
        this.packages.add(node);
        long[] lArray = this.getChartData(node.getClasses().size());
        lArray[1] = lArray[1] + 1L;
        long[] lArray2 = this.getChartData(node.getInboundDependencies().size());
        lArray2[3] = lArray2[3] + 1L;
        long[] lArray3 = this.getChartData(node.getOutboundDependencies().size());
        lArray3[4] = lArray3[4] + 1L;
    }

    @Override
    public void visitInboundPackageNode(PackageNode node) {
        if (this.getStrategy().isInFilter(node)) {
            ++this.nbInbound;
            ++this.nbOutboundPackages;
        }
    }

    @Override
    public void visitOutboundPackageNode(PackageNode node) {
        if (this.getStrategy().isInFilter(node)) {
            ++this.nbOutbound;
            ++this.nbInboundPackages;
        }
    }

    @Override
    public void preprocessClassNode(ClassNode node) {
        super.preprocessClassNode(node);
        this.classes.add(node);
        long[] lArray = this.getChartData(node.getFeatures().size());
        lArray[2] = lArray[2] + 1L;
        long[] lArray2 = this.getChartData(node.getInboundDependencies().size());
        lArray2[5] = lArray2[5] + 1L;
        long[] lArray3 = this.getChartData(node.getOutboundDependencies().size());
        lArray3[6] = lArray3[6] + 1L;
    }

    @Override
    public void visitInboundClassNode(ClassNode node) {
        if (this.getStrategy().isInFilter(node)) {
            ++this.nbInbound;
            ++this.nbOutboundClasses;
        }
    }

    @Override
    public void visitOutboundClassNode(ClassNode node) {
        if (this.getStrategy().isInFilter(node)) {
            ++this.nbOutbound;
            ++this.nbInboundClasses;
        }
    }

    @Override
    public void preprocessFeatureNode(FeatureNode node) {
        super.preprocessFeatureNode(node);
        this.features.add(node);
        long[] lArray = this.getChartData(node.getInboundDependencies().size());
        lArray[7] = lArray[7] + 1L;
        long[] lArray2 = this.getChartData(node.getOutboundDependencies().size());
        lArray2[8] = lArray2[8] + 1L;
    }

    @Override
    public void visitInboundFeatureNode(FeatureNode node) {
        if (this.getStrategy().isInFilter(node)) {
            ++this.nbInbound;
            ++this.nbOutboundFeatures;
        }
    }

    @Override
    public void visitOutboundFeatureNode(FeatureNode node) {
        if (this.getStrategy().isInFilter(node)) {
            ++this.nbOutbound;
            ++this.nbInboundFeatures;
        }
    }
}

