/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.commandline;

import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.commandline.CommandLineSwitchBase;
import com.jeantessier.commandline.Visitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MultipleValuesSwitch
extends CommandLineSwitchBase {
    public MultipleValuesSwitch(String name) {
        this(name, new LinkedList<String>(), false);
    }

    public MultipleValuesSwitch(String name, String defaultValue) {
        this(name, Collections.singletonList(defaultValue), false);
    }

    public MultipleValuesSwitch(String name, String[] defaultValue) {
        this(name, Arrays.asList(defaultValue), false);
    }

    public MultipleValuesSwitch(String name, List<String> defaultValue) {
        this(name, defaultValue, false);
    }

    public MultipleValuesSwitch(String name, boolean mandatory) {
        this(name, new LinkedList<String>(), mandatory);
    }

    public MultipleValuesSwitch(String name, String defaultValue, boolean mandatory) {
        this(name, Collections.singletonList(defaultValue), mandatory);
    }

    public MultipleValuesSwitch(String name, String[] defaultValue, boolean mandatory) {
        this(name, Arrays.asList(defaultValue), mandatory);
    }

    public MultipleValuesSwitch(String name, List<String> defaultValue, boolean mandatory) {
        super(name, new LinkedList<String>(defaultValue), mandatory);
        this.value = new LinkedList();
    }

    @Override
    public Object getValue() {
        Object result = this.getDefaultValue();
        if (!((List)this.value).isEmpty()) {
            result = this.value;
        }
        return result;
    }

    @Override
    public void setValue(Object value) {
        ((List)this.value).add((String)value);
        super.setValue(this.value);
    }

    @Override
    public int parse(String value) throws CommandLineException {
        if (value == null) {
            throw new CommandLineException("Missing mandatory value for switch \"" + this.getName() + "\"");
        }
        this.setValue(value);
        return 2;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitMultipleValuesSwitch(this);
    }
}

