/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.commandline;

import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.commandline.CommandLineSwitch;

public abstract class CommandLineSwitchBase
implements CommandLineSwitch {
    private String name;
    private Object defaultValue;
    protected Object value;
    private boolean present;
    private boolean mandatory;

    public CommandLineSwitchBase(String name) {
        this(name, null, false);
    }

    public CommandLineSwitchBase(String name, Object defaultValue) {
        this(name, defaultValue, false);
    }

    public CommandLineSwitchBase(String name, boolean mandatory) {
        this(name, null, mandatory);
    }

    public CommandLineSwitchBase(String name, Object defaultValue, boolean mandatory) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.mandatory = mandatory;
        this.value = null;
        this.isPresent(false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object getValue() {
        Object result = this.defaultValue;
        if (this.value != null) {
            result = this.value;
        }
        return result;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
        this.isPresent(true);
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    protected void isPresent(boolean present) {
        this.present = present;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public void validate() throws CommandLineException {
        if (this.isMandatory() && !this.isPresent()) {
            throw new CommandLineException("Missing mandatory switch \"" + this.getName() + "\"");
        }
    }

    public String toString() {
        return this.getValue().toString();
    }
}

