/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.DescriptorHelper;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.FeatureRef_info;
import java.io.DataInput;
import java.io.IOException;

public class MethodRef_info
extends FeatureRef_info
implements com.jeantessier.classreader.MethodRef_info {
    public MethodRef_info(ConstantPool constantPool, DataInput in) throws IOException {
        super(constantPool, in);
    }

    @Override
    public boolean isConstructor() {
        return this.getRawNameAndType().getName().equals("<init>");
    }

    @Override
    public boolean isStaticInitializer() {
        return this.getRawNameAndType().getName().equals("<clinit>");
    }

    @Override
    public String getReturnType() {
        return DescriptorHelper.getReturnType(this.getRawNameAndType().getType());
    }

    @Override
    public String getName() {
        String result = this.isConstructor() ? this.getClassSimpleName() : (this.isStaticInitializer() ? "static {}" : this.getRawNameAndType().getName());
        return result;
    }

    @Override
    public String getSignature() {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        if (!this.isStaticInitializer()) {
            result.append(DescriptorHelper.getSignature(this.getRawNameAndType().getType()));
        }
        return result.toString();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitMethodRef_info(this);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (!this.isConstructor() && !this.isStaticInitializer()) {
            result.append(this.getReturnType());
            result.append(" ");
        }
        result.append(this.getFullSignature());
        return result.toString();
    }
}

