/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.SignatureFinder;
import com.jeantessier.classreader.impl.AttributeFactory;
import com.jeantessier.classreader.impl.Attribute_info;
import com.jeantessier.classreader.impl.Classfile;
import com.jeantessier.classreader.impl.Deprecated_attribute;
import com.jeantessier.classreader.impl.Synthetic_attribute;
import com.jeantessier.classreader.impl.UTF8_info;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public abstract class Feature_info
implements com.jeantessier.classreader.Feature_info {
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_PROTECTED = 4;
    private static final int ACC_STATIC = 8;
    private static final int ACC_FINAL = 16;
    private static final int ACC_SYNTHETIC = 4096;
    private Classfile classfile;
    private int accessFlag;
    private int nameIndex;
    private int descriptorIndex;
    private Collection<Attribute_info> attributes = new LinkedList<Attribute_info>();

    public Feature_info(Classfile classfile, DataInput in) throws IOException {
        this(classfile, in, new AttributeFactory());
    }

    public Feature_info(Classfile classfile, DataInput in, AttributeFactory attributeFactory) throws IOException {
        this.classfile = classfile;
        this.accessFlag = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)(this.getFeatureType() + " access flag: " + this.accessFlag));
        this.nameIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)(this.getFeatureType() + " name: " + this.nameIndex + " (" + this.getName() + ")"));
        this.descriptorIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)(this.getFeatureType() + " Descriptor: " + this.descriptorIndex + " (" + this.getDescriptor() + ")"));
        int attributeCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + attributeCount + " " + this.getFeatureType() + " attribute(s)"));
        for (int i = 0; i < attributeCount; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)(this.getFeatureType() + " attribute " + i + ":"));
            this.attributes.add(attributeFactory.create(this.getClassfile().getConstantPool(), this, in));
        }
    }

    @Override
    public Classfile getClassfile() {
        return this.classfile;
    }

    @Override
    public int getAccessFlag() {
        return this.accessFlag;
    }

    @Override
    public boolean isPublic() {
        return (this.getAccessFlag() & 1) != 0;
    }

    @Override
    public boolean isProtected() {
        return (this.getAccessFlag() & 4) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.getAccessFlag() & 2) != 0;
    }

    @Override
    public boolean isPackage() {
        return (this.getAccessFlag() & 7) == 0;
    }

    @Override
    public boolean isStatic() {
        return (this.getAccessFlag() & 8) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.getAccessFlag() & 0x10) != 0;
    }

    @Override
    public int getNameIndex() {
        return this.nameIndex;
    }

    @Override
    public UTF8_info getRawName() {
        return (UTF8_info)this.getClassfile().getConstantPool().get(this.nameIndex);
    }

    @Override
    public String getName() {
        return this.getRawName().getValue();
    }

    @Override
    public String getFullName() {
        return this.getClassfile().getClassName() + "." + this.getName();
    }

    @Override
    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    @Override
    public UTF8_info getRawDescriptor() {
        return (UTF8_info)this.getClassfile().getConstantPool().get(this.descriptorIndex);
    }

    @Override
    public String getDescriptor() {
        return this.getRawDescriptor().getValue();
    }

    public Collection<Attribute_info> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isSynthetic() {
        return this.isSyntheticFromAccessFlag() || this.isSyntheticFromAttribute();
    }

    private boolean isSyntheticFromAccessFlag() {
        return (this.getAccessFlag() & 0x1000) != 0;
    }

    private boolean isSyntheticFromAttribute() {
        boolean result = false;
        Iterator<Attribute_info> i = this.getAttributes().iterator();
        while (!result && i.hasNext()) {
            result = i.next() instanceof Synthetic_attribute;
        }
        return result;
    }

    @Override
    public boolean isDeprecated() {
        boolean result = false;
        Iterator<Attribute_info> i = this.getAttributes().iterator();
        while (!result && i.hasNext()) {
            result = i.next() instanceof Deprecated_attribute;
        }
        return result;
    }

    @Override
    public boolean isGeneric() {
        SignatureFinder finder = new SignatureFinder();
        this.accept(finder);
        return finder.getSignature() != null;
    }

    @Override
    public String getFullSignature() {
        return this.getClassfile().getClassName() + "." + this.getSignature();
    }

    protected abstract String getFeatureType();

    public String toString() {
        return this.getFullName();
    }
}

