/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.AttributeType;
import com.jeantessier.classreader.impl.Attribute_info;
import com.jeantessier.classreader.impl.Class_info;
import com.jeantessier.classreader.impl.ConstantPool;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class Exceptions_attribute
extends Attribute_info
implements com.jeantessier.classreader.Exceptions_attribute {
    private Collection<Class_info> exceptions = new LinkedList<Class_info>();

    public Exceptions_attribute(ConstantPool constantPool, Visitable owner, DataInput in) throws IOException {
        super(constantPool, owner);
        int byteCount = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Attribute length: " + byteCount));
        int exceptionCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + exceptionCount + " exception(s) ..."));
        for (int i = 0; i < exceptionCount; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Exception " + i + ":"));
            Class_info exception = (Class_info)constantPool.get(in.readUnsignedShort());
            this.exceptions.add(exception);
            Logger.getLogger(this.getClass()).debug((Object)("Class " + exception));
        }
    }

    public Collection<Class_info> getExceptions() {
        return this.exceptions;
    }

    @Override
    public String getAttributeName() {
        return AttributeType.EXCEPTIONS.getAttributeName();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitExceptions_attribute(this);
    }
}

