/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.Class_info;
import com.jeantessier.classreader.impl.Code_attribute;
import java.io.DataInput;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ExceptionHandler
implements com.jeantessier.classreader.ExceptionHandler {
    private Code_attribute code;
    private int startPC;
    private int endPC;
    private int handlerPC;
    private int catchTypeIndex;

    public ExceptionHandler(Code_attribute code, DataInput in) throws IOException {
        this.code = code;
        this.startPC = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("start PC: " + this.startPC));
        this.endPC = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("end PC: " + this.endPC));
        this.handlerPC = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("handler PC: " + this.handlerPC));
        this.catchTypeIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("catch type index: " + this.catchTypeIndex + " (" + this.getCatchType() + ")"));
    }

    @Override
    public Code_attribute getCode() {
        return this.code;
    }

    @Override
    public int getStartPC() {
        return this.startPC;
    }

    @Override
    public int getEndPC() {
        return this.endPC;
    }

    @Override
    public int getHandlerPC() {
        return this.handlerPC;
    }

    @Override
    public int getCatchTypeIndex() {
        return this.catchTypeIndex;
    }

    @Override
    public Class_info getRawCatchType() {
        return (Class_info)this.code.getConstantPool().get(this.getCatchTypeIndex());
    }

    @Override
    public String getCatchType() {
        String result = "<none>";
        if (this.getCatchTypeIndex() != 0) {
            result = this.getRawCatchType().getName();
        }
        return result;
    }

    public String toString() {
        return "ExceptionHandler for " + this.getCatchType();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitExceptionHandler(this);
    }
}

