/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.LocalVariable;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.AttributeFactory;
import com.jeantessier.classreader.impl.AttributeType;
import com.jeantessier.classreader.impl.Attribute_info;
import com.jeantessier.classreader.impl.CodeIterator;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.ExceptionHandler;
import com.jeantessier.text.Hex;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class Code_attribute
extends Attribute_info
implements Iterable<Instruction>,
com.jeantessier.classreader.Code_attribute {
    private int maxStack;
    private int maxLocals;
    private byte[] code;
    private Collection<ExceptionHandler> exceptionHandlers = new LinkedList<ExceptionHandler>();
    private Collection<Attribute_info> attributes = new LinkedList<Attribute_info>();

    public Code_attribute(ConstantPool constantPool, Visitable owner, DataInput in) throws IOException {
        this(constantPool, owner, in, new AttributeFactory());
    }

    public Code_attribute(ConstantPool constantPool, Visitable owner, DataInput in, AttributeFactory attributeFactory) throws IOException {
        super(constantPool, owner);
        int byteCount = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Attribute length: " + byteCount));
        this.maxStack = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Code max stack: " + this.maxStack));
        this.maxLocals = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Code max locals: " + this.maxLocals));
        int codeLength = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Code length: " + codeLength));
        this.code = new byte[codeLength];
        in.readFully(this.code);
        Logger.getLogger(this.getClass()).debug((Object)("Read " + codeLength + " byte(s): " + Hex.toString(this.code)));
        int exceptionTableLength = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + exceptionTableLength + " exception handler(s) ..."));
        for (int i = 0; i < exceptionTableLength; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Exception handler " + i + ":"));
            this.exceptionHandlers.add(new ExceptionHandler(this, in));
        }
        int attributeCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + attributeCount + " code attribute(s)"));
        for (int i = 0; i < attributeCount; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("code attribute " + i + ":"));
            this.attributes.add(attributeFactory.create(this.getConstantPool(), this, in));
        }
        if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
            Logger.getLogger(this.getClass()).debug((Object)"Read instructions(s):");
            for (Instruction instr : this) {
                this.logInstruction(instr);
            }
        }
    }

    @Override
    public int getMaxStack() {
        return this.maxStack;
    }

    @Override
    public int getMaxLocals() {
        return this.maxLocals;
    }

    @Override
    public byte[] getCode() {
        return this.code;
    }

    @Override
    public Iterator<Instruction> iterator() {
        return new CodeIterator(this, this.code);
    }

    public Collection<ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public Collection<Attribute_info> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "Code";
    }

    @Override
    public String getAttributeName() {
        return AttributeType.CODE.getAttributeName();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCode_attribute(this);
    }

    private void logInstruction(Instruction instruction) {
        StringBuilder message = new StringBuilder();
        message.append("    ").append(instruction.getStart()).append(": ").append(instruction);
        this.appendIndexedConstantPoolEntry(message, instruction);
        this.appendIndexedLocalVariable(message, instruction);
        this.appendOffset(message, instruction);
        this.appendValue(message, instruction);
        Logger.getLogger(this.getClass()).debug((Object)message);
    }

    private void appendIndexedConstantPoolEntry(StringBuilder message, Instruction instruction) {
        switch (instruction.getOpcode()) {
            case 18: 
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 197: {
                message.append(" ").append(instruction.getIndex()).append(" (").append(instruction.getIndexedConstantPoolEntry()).append(")");
                break;
            }
        }
    }

    private void appendIndexedLocalVariable(StringBuilder message, Instruction instruction) {
        switch (instruction.getOpcode()) {
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.appendLocalVariable(message, instruction.getIndexedLocalVariable());
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 132: 
            case 169: 
            case 196: {
                message.append(" ").append(instruction.getIndex());
                this.appendLocalVariable(message, instruction.getIndexedLocalVariable());
                break;
            }
        }
    }

    private void appendLocalVariable(StringBuilder message, LocalVariable localVariable) {
        String name = "n/a";
        if (localVariable != null) {
            name = localVariable.toString();
        }
        message.append(" (").append(name).append(")");
    }

    private void appendOffset(StringBuilder message, Instruction instruction) {
        switch (instruction.getOpcode()) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: 
            case 200: 
            case 201: {
                message.append(" ");
                if (instruction.getOffset() >= 0) {
                    message.append("+");
                }
                message.append(instruction.getOffset()).append(" (to ").append(instruction.getStart() + instruction.getOffset()).append(")");
                break;
            }
        }
    }

    private void appendValue(StringBuilder message, Instruction helper) {
        switch (helper.getOpcode()) {
            case 16: 
            case 17: {
                message.append(" ").append(helper.getValue());
                break;
            }
            case 132: {
                message.append(" by ").append(helper.getValue());
                break;
            }
            case 196: {
                if (helper.getByte(1) != 132) break;
                message.append(" by ").append(helper.getValue());
                break;
            }
        }
    }
}

