/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.AttributeFactory;
import com.jeantessier.classreader.impl.Attribute_info;
import com.jeantessier.classreader.impl.Class_info;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.Deprecated_attribute;
import com.jeantessier.classreader.impl.EnclosingMethod_attribute;
import com.jeantessier.classreader.impl.Field_info;
import com.jeantessier.classreader.impl.InnerClass;
import com.jeantessier.classreader.impl.InnerClasses_attribute;
import com.jeantessier.classreader.impl.Method_info;
import com.jeantessier.classreader.impl.Signature_attribute;
import com.jeantessier.classreader.impl.Synthetic_attribute;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class Classfile
implements com.jeantessier.classreader.Classfile {
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_FINAL = 16;
    private static final int ACC_SUPER = 32;
    private static final int ACC_INTERFACE = 512;
    private static final int ACC_ABSTRACT = 1024;
    private static final int ACC_SYNTHETIC = 4096;
    private static final int ACC_ANNOTATION = 8192;
    private static final int ACC_ENUM = 16384;
    private ClassfileLoader loader;
    private int magicNumber;
    private int minorVersion;
    private int majorVersion;
    private ConstantPool constantPool;
    private int accessFlag;
    private int classIndex;
    private int superclassIndex;
    private Collection<Class_info> interfaces = new LinkedList<Class_info>();
    private Collection<Field_info> fields = new LinkedList<Field_info>();
    private Collection<Method_info> methods = new LinkedList<Method_info>();
    private Collection<Attribute_info> attributes = new LinkedList<Attribute_info>();

    public Classfile(ClassfileLoader loader, DataInput in) throws IOException {
        this(loader, in, new AttributeFactory());
    }

    public Classfile(ClassfileLoader loader, DataInput in, AttributeFactory attributeFactory) throws IOException {
        this.loader = loader;
        this.magicNumber = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("magic number = 0x" + Integer.toHexString(this.magicNumber).toUpperCase()));
        if (this.magicNumber != -889275714) {
            throw new IOException("Bad magic number");
        }
        this.minorVersion = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("minor version = " + this.minorVersion));
        this.majorVersion = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("major version = " + this.majorVersion));
        Logger.getLogger(this.getClass()).debug((Object)"Reading the constant pool ...");
        this.constantPool = new ConstantPool(this, in);
        Logger.getLogger(this.getClass()).debug((Object)this.constantPool);
        this.accessFlag = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("accessFlag = " + this.accessFlag));
        this.classIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("thisClass = " + this.classIndex + " (" + this.getClassName() + ")"));
        this.superclassIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("superclass = " + this.superclassIndex + " (" + this.getSuperclassName() + ")"));
        int interfaceCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + interfaceCount + " interface(s)"));
        for (int i = 0; i < interfaceCount; ++i) {
            Class_info interfaceInfo = (Class_info)this.constantPool.get(in.readUnsignedShort());
            Logger.getLogger(this.getClass()).debug((Object)("    " + interfaceInfo.getName()));
            this.interfaces.add(interfaceInfo);
        }
        int fieldCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + fieldCount + " field(s)"));
        for (int i = 0; i < fieldCount; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Field " + i + ":"));
            this.fields.add(new Field_info(this, in));
        }
        int methodCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + methodCount + " method(s)"));
        for (int i = 0; i < methodCount; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Method " + i + ":"));
            this.methods.add(new Method_info(this, in));
        }
        int attributeCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + attributeCount + " class attribute(s)"));
        for (int i = 0; i < attributeCount; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Attribute " + i + ":"));
            this.attributes.add(attributeFactory.create(this.constantPool, this, in));
        }
    }

    Classfile(ClassfileLoader loader, ConstantPool constantPool, int accessFlag, int classIndex, int superclassIndex, Iterable<Class_info> interfaces, Iterable<Field_info> fields, Iterable<Method_info> methods, Iterable<Attribute_info> attributes) {
        this.loader = loader;
        this.constantPool = constantPool;
        this.accessFlag = accessFlag;
        this.classIndex = classIndex;
        this.superclassIndex = superclassIndex;
        for (Class_info interfaceInfo : interfaces) {
            this.interfaces.add(interfaceInfo);
        }
        for (Field_info field : fields) {
            this.fields.add(field);
        }
        for (Method_info method : methods) {
            this.methods.add(method);
        }
        for (Attribute_info attribute : attributes) {
            this.attributes.add(attribute);
        }
    }

    @Override
    public ClassfileLoader getLoader() {
        return this.loader;
    }

    @Override
    public int getMagicNumber() {
        return this.magicNumber;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    @Override
    public int getAccessFlag() {
        return this.accessFlag;
    }

    @Override
    public int getClassIndex() {
        return this.classIndex;
    }

    @Override
    public Class_info getRawClass() {
        return (Class_info)this.getConstantPool().get(this.getClassIndex());
    }

    @Override
    public String getClassName() {
        return this.getRawClass().getName();
    }

    @Override
    public String getPackageName() {
        return this.getRawClass().getPackageName();
    }

    @Override
    public String getSimpleName() {
        return this.getRawClass().getSimpleName();
    }

    @Override
    public int getSuperclassIndex() {
        return this.superclassIndex;
    }

    @Override
    public Class_info getRawSuperclass() {
        return (Class_info)this.getConstantPool().get(this.getSuperclassIndex());
    }

    @Override
    public String getSuperclassName() {
        String result = "";
        if (this.getSuperclassIndex() != 0) {
            result = this.getRawSuperclass().getName();
        }
        return result;
    }

    @Override
    public Class_info getInterface(String name) {
        for (Class_info interfaceInfo : this.interfaces) {
            if (!interfaceInfo.getName().equals(name)) continue;
            return interfaceInfo;
        }
        return null;
    }

    public Collection<Class_info> getAllInterfaces() {
        return this.interfaces;
    }

    public Collection<Field_info> getAllFields() {
        return this.fields;
    }

    @Override
    public Field_info getField(String name) {
        for (Field_info field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    @Override
    public com.jeantessier.classreader.Field_info locateField(String name) {
        com.jeantessier.classreader.Field_info inheritedField;
        Field_info localField = this.getField(name);
        if (localField != null) {
            return localField;
        }
        com.jeantessier.classreader.Classfile superclass = this.getLoader().getClassfile(this.getSuperclassName());
        if (superclass != null && (inheritedField = superclass.locateField(name)) != null && (inheritedField.isPublic() || inheritedField.isProtected() || inheritedField.isPackage() && inheritedField.getClassfile().getPackageName().equals(superclass.getPackageName()))) {
            return inheritedField;
        }
        for (Class_info interfaceInfo : this.getAllInterfaces()) {
            com.jeantessier.classreader.Field_info interfaceField;
            com.jeantessier.classreader.Classfile interfaceClassfile = this.getLoader().getClassfile(interfaceInfo.getName());
            if (interfaceClassfile == null || (interfaceField = interfaceClassfile.locateField(name)) == null || !interfaceField.isPublic() && !interfaceField.isProtected()) continue;
            return interfaceField;
        }
        return null;
    }

    public Collection<Method_info> getAllMethods() {
        return this.methods;
    }

    @Override
    public Method_info getMethod(String signature) {
        for (Method_info method : this.methods) {
            if (!method.getSignature().equals(signature)) continue;
            return method;
        }
        return null;
    }

    @Override
    public com.jeantessier.classreader.Method_info locateMethod(String signature) {
        com.jeantessier.classreader.Method_info inheritedMethod;
        Method_info localMethod = this.getMethod(signature);
        if (localMethod != null) {
            return localMethod;
        }
        com.jeantessier.classreader.Classfile superclass = this.getLoader().getClassfile(this.getSuperclassName());
        if (superclass != null && (inheritedMethod = superclass.locateMethod(signature)) != null && (inheritedMethod.isPublic() || inheritedMethod.isProtected() || inheritedMethod.isPackage() && inheritedMethod.getClassfile().getPackageName().equals(superclass.getPackageName()))) {
            return inheritedMethod;
        }
        for (Class_info inferfaceInfo : this.getAllInterfaces()) {
            com.jeantessier.classreader.Method_info interfaceMethod;
            com.jeantessier.classreader.Classfile interfaceClassfile = this.getLoader().getClassfile(inferfaceInfo.getName());
            if (interfaceClassfile == null || (interfaceMethod = interfaceClassfile.locateMethod(signature)) == null || !interfaceMethod.isPublic() && !interfaceMethod.isProtected()) continue;
            return interfaceMethod;
        }
        return null;
    }

    public Collection<Attribute_info> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isPublic() {
        return (this.getAccessFlag() & 1) != 0;
    }

    @Override
    public boolean isPackage() {
        return (this.getAccessFlag() & 1) == 0;
    }

    @Override
    public boolean isFinal() {
        return (this.getAccessFlag() & 0x10) != 0;
    }

    @Override
    public boolean isSuper() {
        return (this.getAccessFlag() & 0x20) != 0;
    }

    @Override
    public boolean isInterface() {
        return (this.getAccessFlag() & 0x200) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.getAccessFlag() & 0x400) != 0;
    }

    @Override
    public boolean isAnnotation() {
        return (this.getAccessFlag() & 0x2000) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.getAccessFlag() & 0x4000) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return this.isSyntheticFromAccessFlag() || this.isSyntheticFromAttribute();
    }

    private boolean isSyntheticFromAccessFlag() {
        return (this.getAccessFlag() & 0x1000) != 0;
    }

    private boolean isSyntheticFromAttribute() {
        boolean result = false;
        Iterator<Attribute_info> i = this.getAttributes().iterator();
        while (!result && i.hasNext()) {
            result = i.next() instanceof Synthetic_attribute;
        }
        return result;
    }

    @Override
    public boolean isDeprecated() {
        boolean result = false;
        Iterator<Attribute_info> i = this.getAttributes().iterator();
        while (!result && i.hasNext()) {
            result = i.next() instanceof Deprecated_attribute;
        }
        return result;
    }

    @Override
    public boolean isGeneric() {
        boolean result = false;
        Iterator<Attribute_info> i = this.getAttributes().iterator();
        while (!result && i.hasNext()) {
            result = i.next() instanceof Signature_attribute;
        }
        return result;
    }

    @Override
    public String getDeclaration() {
        StringBuffer result;
        block8: {
            block7: {
                result = new StringBuffer();
                if (this.isPublic()) {
                    result.append("public ");
                }
                if (this.isFinal()) {
                    result.append("final ");
                }
                if (!this.isInterface()) break block7;
                result.append("interface ").append(this.getClassName());
                if (this.getAllInterfaces().size() == 0) break block8;
                result.append(" extends ");
                Iterator<Class_info> i = this.getAllInterfaces().iterator();
                while (i.hasNext()) {
                    result.append(i.next());
                    if (!i.hasNext()) continue;
                    result.append(", ");
                }
                break block8;
            }
            if (this.isAbstract()) {
                result.append("abstract ");
            }
            result.append("class ").append(this.getClassName());
            if (this.getSuperclassIndex() != 0) {
                result.append(" extends ").append(this.getSuperclassName());
            }
            if (this.getAllInterfaces().size() != 0) {
                result.append(" implements ");
                Iterator<Class_info> i = this.getAllInterfaces().iterator();
                while (i.hasNext()) {
                    result.append(i.next());
                    if (!i.hasNext()) continue;
                    result.append(", ");
                }
            }
        }
        return result.toString();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitClassfile(this);
    }

    public String toString() {
        return this.getClassName();
    }

    @Override
    public boolean isInnerClass() {
        return this.getMatchingInnerClass() != null;
    }

    @Override
    public boolean isMemberClass() {
        boolean result = false;
        InnerClass innerClass = this.getMatchingInnerClass();
        if (innerClass != null) {
            result = innerClass.isMemberClass();
        }
        return result;
    }

    @Override
    public boolean isLocalClass() {
        boolean result = false;
        InnerClass innerClass = this.getMatchingInnerClass();
        EnclosingMethod_attribute enclosingMethod = this.getEnclosingMethod();
        if (innerClass != null && enclosingMethod != null) {
            result = !innerClass.isAnonymousClass();
        }
        return result;
    }

    @Override
    public boolean isAnonymousClass() {
        boolean result = false;
        InnerClass innerClass = this.getMatchingInnerClass();
        if (innerClass != null) {
            result = innerClass.isAnonymousClass();
        }
        return result;
    }

    private InnerClass getMatchingInnerClass() {
        InnerClass result = null;
        for (Attribute_info attribute : this.getAttributes()) {
            if (!(attribute instanceof InnerClasses_attribute)) continue;
            for (InnerClass innerClass : ((InnerClasses_attribute)attribute).getInnerClasses()) {
                if (!innerClass.getInnerClassInfo().equals(this.getClassName())) continue;
                result = innerClass;
            }
        }
        return result;
    }

    private EnclosingMethod_attribute getEnclosingMethod() {
        EnclosingMethod_attribute result = null;
        for (Attribute_info attribute : this.getAttributes()) {
            if (!(attribute instanceof EnclosingMethod_attribute)) continue;
            result = (EnclosingMethod_attribute)attribute;
        }
        return result;
    }
}

