/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.ClassNameHelper;
import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.CollectorBase;
import com.jeantessier.classreader.FieldRef_info;
import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.InterfaceMethodRef_info;
import com.jeantessier.classreader.MethodRef_info;
import com.jeantessier.classreader.Method_info;
import org.apache.oro.text.perl.Perl5Util;

public class FeatureDependencyCollector
extends CollectorBase {
    private static final Perl5Util perl = new Perl5Util();
    private Class_info thisClass;

    @Override
    public void visitClassfile(Classfile classfile) {
        this.thisClass = classfile.getRawClass();
        classfile.getConstantPool().accept(this);
    }

    @Override
    public void visitFieldRef_info(FieldRef_info entry) {
        if (entry.getRawClass() != this.thisClass) {
            this.add(entry.getClassName() + "." + entry.getRawNameAndType().getName());
        }
    }

    @Override
    public void visitMethodRef_info(MethodRef_info entry) {
        if (entry.getRawClass() != this.thisClass && !perl.match("/<.*init>/", entry.getRawNameAndType().getName())) {
            this.add(entry.getClassName() + "." + entry.getRawNameAndType().getName());
        }
    }

    @Override
    public void visitInterfaceMethodRef_info(InterfaceMethodRef_info entry) {
        if (entry.getRawClass() != this.thisClass) {
            this.add(entry.getClassName() + "." + entry.getRawNameAndType().getName());
        }
    }

    @Override
    public void visitMethod_info(Method_info entry) {
        this.processSignature(entry.getDescriptor());
        super.visitMethod_info(entry);
    }

    @Override
    public void visitInstruction(Instruction helper) {
        switch (helper.getOpcode()) {
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                helper.getIndexedConstantPoolEntry().accept(this);
                break;
            }
        }
        super.visitInstruction(helper);
    }

    private void processSignature(String str) {
        int startPos;
        int currentPos = 0;
        while ((startPos = str.indexOf(76, currentPos)) != -1) {
            int endPos = str.indexOf(59, startPos);
            if (endPos != -1) {
                String candidate = str.substring(startPos + 1, endPos);
                if (!this.thisClass.getName().equals(candidate)) {
                    this.add(ClassNameHelper.path2ClassName(candidate));
                }
                currentPos = endPos + 1;
                continue;
            }
            currentPos = startPos + 1;
        }
    }
}

