/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.ClassfileFactory;
import com.jeantessier.classreader.ClassfileLoaderDispatcher;
import com.jeantessier.classreader.ClassfileLoaderEventSource;
import com.jeantessier.classreader.impl.DefaultClassfileFactory;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class AggregatingClassfileLoader
extends ClassfileLoaderEventSource {
    private Map<String, Classfile> classfiles = new TreeMap<String, Classfile>();

    public AggregatingClassfileLoader() {
        this(new DefaultClassfileFactory());
    }

    private AggregatingClassfileLoader(ClassfileFactory factory) {
        super(factory);
    }

    public AggregatingClassfileLoader(ClassfileLoaderDispatcher dispatcher) {
        this(new DefaultClassfileFactory(), dispatcher);
    }

    private AggregatingClassfileLoader(ClassfileFactory factory, ClassfileLoaderDispatcher dispatcher) {
        super(factory, dispatcher);
    }

    @Override
    public Classfile getClassfile(String name) {
        return this.classfiles.get(name);
    }

    @Override
    public Collection<Classfile> getAllClassfiles() {
        return Collections.unmodifiableCollection(this.classfiles.values());
    }

    @Override
    public Collection<String> getAllClassNames() {
        return Collections.unmodifiableCollection(this.classfiles.keySet());
    }

    @Override
    protected Classfile load(DataInput in) throws IOException {
        Classfile result = this.getFactory().create(this, in);
        this.classfiles.put(result.getClassName(), result);
        return result;
    }
}

