/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.renderer.lwjgl.render;

import de.lessvoid.nifty.renderer.lwjgl.render.font.CharacterInfo;
import de.lessvoid.nifty.renderer.lwjgl.render.font.Font;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderFont;

public class LwjglRenderFont
implements RenderFont {
    private Font font;

    public LwjglRenderFont(String name, RenderDevice device) {
        this.font = new Font(device);
        this.font.init(name);
    }

    public int getHeight() {
        return this.font.getHeight();
    }

    public int getWidth(String text) {
        return this.font.getStringWidth(text);
    }

    public static int getKerning(CharacterInfo charInfoC, char nextc) {
        Integer kern = charInfoC.getKerning().get(Character.valueOf(nextc));
        if (kern != null) {
            return kern;
        }
        return 0;
    }

    public Integer getCharacterAdvance(char currentCharacter, char nextCharacter, float size) {
        CharacterInfo currentCharacterInfo = this.font.getChar(currentCharacter);
        if (currentCharacterInfo == null) {
            return null;
        }
        return new Integer((int)((float)currentCharacterInfo.getXadvance() * size + (float)LwjglRenderFont.getKerning(currentCharacterInfo, nextCharacter)));
    }

    public Font getFont() {
        return this.font;
    }

    public void dispose() {
    }
}

