/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools;

public class SizeValue {
    private static final String PIXEL = "px";
    private static final String PERCENT = "%";
    private static final String WIDTH_SUFFIX = "w";
    private static final String HEIGHT_SUFFIX = "h";
    private static final String WILDCARD = "*";
    private static final float MAX_PERCENT = 100.0f;
    private String value;
    private float percentValue;
    private float pixelValue;
    private boolean hasWidthSuffix;
    private boolean hasHeightSuffix;

    public SizeValue(String valueParam) {
        if (valueParam != null) {
            if (valueParam.endsWith("%w")) {
                this.hasWidthSuffix = true;
                this.value = valueParam.substring(0, valueParam.length() - 1);
            } else if (valueParam.endsWith("%h")) {
                this.hasHeightSuffix = true;
                this.value = valueParam.substring(0, valueParam.length() - 1);
            } else {
                this.value = valueParam;
            }
        } else {
            this.value = valueParam;
        }
        this.percentValue = this.getPercentValue();
        this.pixelValue = this.getPixelValue();
    }

    public boolean isPercentOrPixel() {
        return this.isPercent() || this.isPixel();
    }

    public float getValue(float range) {
        if (this.isPercent()) {
            return range / 100.0f * this.percentValue;
        }
        if (this.isPixel()) {
            return this.pixelValue;
        }
        return -1.0f;
    }

    public int getValueAsInt(float range) {
        return (int)this.getValue(range);
    }

    private float getPercentValue() {
        if (this.isPercent()) {
            String percent = this.value.substring(0, this.value.length() - PERCENT.length());
            return Float.valueOf(percent).floatValue();
        }
        return 0.0f;
    }

    private int getPixelValue() {
        if (this.isPixel()) {
            if (this.hasNoSuffix()) {
                return Integer.valueOf(this.value);
            }
            String pixel = this.value.substring(0, this.value.length() - PIXEL.length());
            return Integer.valueOf(pixel);
        }
        return 0;
    }

    private boolean isPercent() {
        if (this.value == null) {
            return false;
        }
        return this.value.endsWith(PERCENT);
    }

    public boolean isPixel() {
        if (this.value == null) {
            return false;
        }
        return !this.value.equals(WILDCARD) && (this.value.endsWith(PIXEL) || this.hasNoSuffix());
    }

    private boolean hasNoSuffix() {
        if (this.value == null) {
            return false;
        }
        return !this.value.endsWith(PIXEL) && !this.value.endsWith(PERCENT) && !this.value.endsWith(WIDTH_SUFFIX) && !this.value.endsWith(HEIGHT_SUFFIX);
    }

    public String toString() {
        return this.value;
    }

    public boolean hasWidthSuffix() {
        return this.hasWidthSuffix;
    }

    public boolean hasHeightSuffix() {
        return this.hasHeightSuffix;
    }

    public boolean hasWildcard() {
        return WILDCARD.equals(this.value);
    }
}

