/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types;

import de.lessvoid.nifty.loaderv2.types.AttributesType;
import de.lessvoid.nifty.loaderv2.types.EffectsType;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.loaderv2.types.InteractType;
import de.lessvoid.nifty.loaderv2.types.XmlBaseType;
import de.lessvoid.nifty.loaderv2.types.resolver.style.StyleResolver;
import de.lessvoid.nifty.tools.StringHelper;
import de.lessvoid.xml.xpp3.Attributes;

public class StyleType
extends XmlBaseType {
    private AttributesType attributesType;
    private EffectsType effectsType;
    private InteractType interactType;

    public StyleType() {
    }

    public StyleType(Attributes attributes) {
        super(attributes);
    }

    public void setAttributes(AttributesType styleAttributesTypeParam) {
        this.attributesType = styleAttributesTypeParam;
    }

    public void setEffect(EffectsType effectTypeParam) {
        this.effectsType = effectTypeParam;
    }

    public void setInteract(InteractType interactTypeParam) {
        this.interactType = interactTypeParam;
    }

    @Override
    public String output(int offset) {
        String result = StringHelper.whitespace(offset) + "<style> (" + this.getAttributes().toString() + ")";
        if (this.attributesType != null) {
            result = result + "\n" + this.attributesType.output(offset + 1);
        }
        if (this.interactType != null) {
            result = result + "\n" + this.interactType.output(offset + 1);
        }
        if (this.effectsType != null) {
            result = result + "\n" + this.effectsType.output(offset + 1);
        }
        return result;
    }

    public String getStyleId() {
        return this.getAttributes().get("id");
    }

    public String getBaseStyleId() {
        return this.getAttributes().get("base");
    }

    public void applyTo(ElementType elementType, StyleResolver styleResolver) {
        this.applyToBaseStyleInternal(styleResolver, elementType);
        this.applyToInternal(elementType);
    }

    void applyToInternal(ElementType elementType) {
        if (this.attributesType != null) {
            this.attributesType.apply(elementType.getAttributes(), this.getStyleId());
        }
        if (this.effectsType != null) {
            this.effectsType.apply(elementType.getEffects(), this.getStyleId());
        }
        if (this.interactType != null) {
            this.interactType.apply(elementType.getInteract(), this.getStyleId());
        }
    }

    void applyToBaseStyleInternal(StyleResolver styleResolver, ElementType elementType) {
        StyleType baseStyle = styleResolver.resolve(this.getBaseStyleId());
        if (baseStyle != null) {
            baseStyle.applyTo(elementType, styleResolver);
        }
    }
}

