/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.layout.manager;

import de.lessvoid.nifty.layout.Box;
import de.lessvoid.nifty.layout.BoxConstraints;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.layout.align.HorizontalAlign;
import de.lessvoid.nifty.layout.align.VerticalAlign;
import de.lessvoid.nifty.layout.manager.LayoutManager;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.List;
import java.util.logging.Logger;

public class CenterLayout
implements LayoutManager {
    private Logger log = Logger.getLogger(CenterLayout.class.getName());

    @Override
    public void layoutElements(LayoutPart rootElement, List<LayoutPart> elements) {
        if (rootElement == null || elements == null || elements.size() == 0) {
            return;
        }
        if (elements.size() > 1) {
            this.log.warning("You're using a centerLayout element but you've added more than one child element to it. centerLayout only supports one element! Odd things will happen when used with more than one element :)");
        }
        Box rootBox = rootElement.getBox();
        BoxConstraints rootBoxConstraints = rootElement.getBoxConstraints();
        Box box = elements.get(0).getBox();
        BoxConstraints constraint = elements.get(0).getBoxConstraints();
        if (constraint.getWidth() != null && constraint.getWidth().hasHeightSuffix()) {
            this.handleVerticalAlignment(rootBox, rootBoxConstraints, box, constraint);
            this.handleHorizontalAlignment(rootBox, rootBoxConstraints, box, constraint);
        } else if (constraint.getHeight() != null && constraint.getHeight().hasWidthSuffix()) {
            this.handleHorizontalAlignment(rootBox, rootBoxConstraints, box, constraint);
            this.handleVerticalAlignment(rootBox, rootBoxConstraints, box, constraint);
        } else {
            this.handleVerticalAlignment(rootBox, rootBoxConstraints, box, constraint);
            this.handleHorizontalAlignment(rootBox, rootBoxConstraints, box, constraint);
        }
    }

    void handleHorizontalAlignment(Box rootBox, BoxConstraints rootBoxConstraints, Box box, BoxConstraints constraint) {
        if (constraint.getWidth() != null) {
            this.handleWidthConstraint(rootBox, rootBoxConstraints, box, constraint);
        } else {
            box.setX(rootBox.getX() + rootBoxConstraints.getPaddingLeft().getValueAsInt(rootBox.getWidth()));
            box.setWidth(rootBox.getWidth() - rootBoxConstraints.getPaddingLeft().getValueAsInt(rootBox.getWidth()) - rootBoxConstraints.getPaddingRight().getValueAsInt(rootBox.getWidth()));
        }
    }

    void handleVerticalAlignment(Box rootBox, BoxConstraints rootBoxConstraints, Box box, BoxConstraints constraint) {
        if (constraint.getHeight() != null) {
            this.handleHeightConstraint(rootBox, rootBoxConstraints, box, constraint);
        } else {
            box.setY(rootBox.getY() + rootBoxConstraints.getPaddingTop().getValueAsInt(rootBox.getHeight()));
            box.setHeight(rootBox.getHeight() - rootBoxConstraints.getPaddingTop().getValueAsInt(rootBox.getHeight()) - rootBoxConstraints.getPaddingBottom().getValueAsInt(rootBox.getHeight()));
        }
    }

    private void handleWidthConstraint(Box rootBox, BoxConstraints rootBoxConstraints, Box box, BoxConstraints constraint) {
        int rootBoxX = rootBox.getX() + rootBoxConstraints.getPaddingLeft().getValueAsInt(rootBox.getWidth());
        int rootBoxWidth = rootBox.getWidth() - rootBoxConstraints.getPaddingLeft().getValueAsInt(rootBox.getWidth()) - rootBoxConstraints.getPaddingRight().getValueAsInt(rootBox.getWidth());
        int boxWidth = (int)constraint.getWidth().getValue(rootBoxWidth);
        if (constraint.getWidth().hasHeightSuffix()) {
            boxWidth = (int)constraint.getWidth().getValue(box.getHeight());
        }
        box.setWidth(boxWidth);
        if (constraint.getHorizontalAlign() == HorizontalAlign.left) {
            box.setX(rootBoxX);
        } else if (constraint.getHorizontalAlign() == HorizontalAlign.right) {
            box.setX(rootBoxX + rootBox.getWidth() - rootBoxConstraints.getPaddingRight().getValueAsInt(rootBox.getWidth()) - boxWidth);
        } else {
            box.setX(rootBoxX + (rootBoxWidth - boxWidth) / 2);
        }
    }

    private void handleHeightConstraint(Box rootBox, BoxConstraints rootBoxConstraints, Box box, BoxConstraints constraint) {
        int rootBoxY = rootBox.getY() + rootBoxConstraints.getPaddingTop().getValueAsInt(rootBox.getHeight());
        int rootBoxHeight = rootBox.getHeight() - rootBoxConstraints.getPaddingTop().getValueAsInt(rootBox.getHeight()) - rootBoxConstraints.getPaddingBottom().getValueAsInt(rootBox.getHeight());
        int boxHeight = (int)constraint.getHeight().getValue(rootBoxHeight);
        if (constraint.getHeight().hasWidthSuffix()) {
            boxHeight = (int)constraint.getHeight().getValue(box.getWidth());
        }
        box.setHeight(boxHeight);
        if (constraint.getVerticalAlign() == VerticalAlign.top) {
            box.setY(rootBoxY);
        } else if (constraint.getVerticalAlign() == VerticalAlign.bottom) {
            box.setY(rootBox.getHeight() - rootBoxConstraints.getPaddingTop().getValueAsInt(rootBox.getHeight()) - boxHeight);
        } else {
            box.setY(rootBoxY + (rootBoxHeight - boxHeight) / 2);
        }
    }

    @Override
    public SizeValue calculateConstraintWidth(LayoutPart root, List<LayoutPart> children) {
        if (children.isEmpty()) {
            return null;
        }
        LayoutPart firstChild = children.get(0);
        if (firstChild == null) {
            return null;
        }
        BoxConstraints constraint = firstChild.getBoxConstraints();
        if (constraint == null) {
            return null;
        }
        return new SizeValue(constraint.getWidth().getValueAsInt(0.0f) + root.getBoxConstraints().getPaddingLeft().getValueAsInt(root.getBox().getWidth()) + root.getBoxConstraints().getPaddingRight().getValueAsInt(root.getBox().getWidth()) + "px");
    }

    @Override
    public SizeValue calculateConstraintHeight(LayoutPart root, List<LayoutPart> children) {
        if (children.isEmpty()) {
            return null;
        }
        LayoutPart firstChild = children.get(0);
        if (firstChild == null) {
            return null;
        }
        BoxConstraints constraint = firstChild.getBoxConstraints();
        if (constraint == null) {
            return null;
        }
        return new SizeValue(constraint.getHeight().getValueAsInt(0.0f) + root.getBoxConstraints().getPaddingTop().getValueAsInt(root.getBox().getHeight()) + root.getBoxConstraints().getPaddingBottom().getValueAsInt(root.getBox().getHeight()) + "px");
    }
}

