/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements.render;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ElementRenderer;
import de.lessvoid.nifty.elements.tools.FontHelper;
import de.lessvoid.nifty.elements.tools.TextBreak;
import de.lessvoid.nifty.layout.align.HorizontalAlign;
import de.lessvoid.nifty.layout.align.VerticalAlign;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.ArrayList;

public class TextRenderer
implements ElementRenderer {
    private RenderFont font = new RenderFontNull();
    private String originalText;
    private String[] textLines = new String[0];
    private int maxWidth;
    private int xoffsetHack = 0;
    private int selectionStart = -1;
    private int selectionEnd = -1;
    private Color textSelectionColor;
    private VerticalAlign textVAlign = VerticalAlign.center;
    private HorizontalAlign textHAlign = HorizontalAlign.center;
    private Color color = Color.WHITE;
    private boolean lineWrapping = false;
    private boolean isCalculatedLineWrapping = false;
    private SizeValue textLineHeight;
    private SizeValue textMinHeight;
    private Nifty nifty;

    public TextRenderer(Nifty nifty) {
        this.nifty = nifty;
        this.originalText = "";
    }

    public TextRenderer(Nifty nifty, RenderFont newFont, String newText) {
        this.nifty = nifty;
        this.init(newFont, newText);
    }

    public void setText(String newText) {
        if (newText == null) {
            return;
        }
        this.initText(newText);
    }

    private void init(RenderFont newFont, String newText) {
        this.font = newFont;
        this.initText(newText);
    }

    private void initText(String param) {
        String newText = this.nifty.specialValuesReplace(param);
        if (this.lineWrapping && this.isCalculatedLineWrapping) {
            this.isCalculatedLineWrapping = false;
        }
        this.originalText = newText;
        this.textLines = newText.split("\n", -1);
        this.maxWidth = 0;
        for (String line : this.textLines) {
            int lineWidth = this.font.getWidth(line);
            if (lineWidth <= this.maxWidth) continue;
            this.maxWidth = lineWidth;
        }
    }

    @Override
    public void render(Element w, NiftyRenderEngine r) {
        if (this.textLines.length == 0 || this.textLines.length == 1 && this.textLines[0].length() == 0) {
            return;
        }
        this.renderLines(w, r, this.textLines);
    }

    private void renderLines(Element w, NiftyRenderEngine r, String[] lines) {
        RenderFont font = this.ensureFont(r);
        boolean stateSaved = this.prepareRenderEngine(r, font);
        int y = TextRenderer.getStartYWithVerticalAlign(lines.length * font.getHeight(), w.getHeight(), this.textVAlign);
        for (String line : lines) {
            int yy = w.getY() + y;
            if (Math.abs(this.xoffsetHack) > 0) {
                int fittingOffset = FontHelper.getVisibleCharactersFromStart(font, line, Math.abs(this.xoffsetHack), 1.0f);
                String cut = line.substring(0, fittingOffset);
                String substring = line.substring(fittingOffset, line.length());
                int xx = w.getX() + this.xoffsetHack + font.getWidth(cut);
                this.renderLine(xx, yy, substring, r, this.selectionStart - fittingOffset, this.selectionEnd - fittingOffset);
            } else {
                int xx = w.getX() + TextRenderer.getStartXWithHorizontalAlign(font.getWidth(line), w.getWidth(), this.textHAlign);
                this.renderLine(xx, yy, line, r, this.selectionStart, this.selectionEnd);
            }
            y += font.getHeight();
        }
        this.restoreRenderEngine(r, stateSaved);
    }

    private boolean prepareRenderEngine(NiftyRenderEngine r, RenderFont font) {
        if (!r.isColorChanged()) {
            if (r.isColorAlphaChanged()) {
                r.setColorIgnoreAlpha(this.color);
            } else {
                r.setColor(this.color);
            }
        }
        boolean stateSaved = false;
        if (r.getFont() == null) {
            r.saveState(null);
            r.setFont(font);
            stateSaved = true;
        }
        return stateSaved;
    }

    private void restoreRenderEngine(NiftyRenderEngine r, boolean stateSaved) {
        if (stateSaved) {
            r.restoreState();
        }
    }

    private RenderFont ensureFont(NiftyRenderEngine r) {
        RenderFont font = r.getFont();
        if (font == null) {
            font = this.font;
        }
        return font;
    }

    protected static int getStartYWithVerticalAlign(int textHeight, int elementHeight, VerticalAlign verticalAlign) {
        if (VerticalAlign.top == verticalAlign) {
            return 0;
        }
        if (VerticalAlign.center == verticalAlign) {
            return (elementHeight - textHeight) / 2;
        }
        if (VerticalAlign.bottom == verticalAlign) {
            return elementHeight - textHeight;
        }
        return 0;
    }

    protected static int getStartXWithHorizontalAlign(int textWidth, int elementWidth, HorizontalAlign horizontalAlign) {
        if (HorizontalAlign.left == horizontalAlign) {
            return 0;
        }
        if (HorizontalAlign.center == horizontalAlign) {
            return (elementWidth - textWidth) / 2;
        }
        if (HorizontalAlign.right == horizontalAlign) {
            return elementWidth - textWidth;
        }
        return 0;
    }

    private void renderLine(int xx, int yy, String line, NiftyRenderEngine r, int selStart, int selEnd) {
        r.renderText(line, xx, yy, selStart, selEnd, this.textSelectionColor);
    }

    public int getTextWidth() {
        return this.maxWidth;
    }

    public int getTextHeight() {
        int calculatedHeight = this.font.getHeight() * this.textLines.length;
        if (this.textLineHeight != null) {
            calculatedHeight = this.textLineHeight.getValueAsInt(1.0f) * this.textLines.length;
        }
        if (this.textMinHeight != null && calculatedHeight < this.textMinHeight.getValueAsInt(1.0f)) {
            return this.textMinHeight.getValueAsInt(1.0f);
        }
        return calculatedHeight;
    }

    public void setXoffsetHack(int newXoffsetHack) {
        this.xoffsetHack = newXoffsetHack;
    }

    public RenderFont getFont() {
        return this.font;
    }

    public void setSelection(int selectionStartParam, int selectionEndParam) {
        this.selectionStart = selectionStartParam;
        this.selectionEnd = selectionEndParam;
    }

    public void setFont(RenderFont fontParam) {
        if (fontParam == null) {
            return;
        }
        this.font = fontParam;
    }

    public void setTextSelectionColor(Color textSelectionColorParam) {
        this.textSelectionColor = textSelectionColorParam;
    }

    public void setTextVAlign(VerticalAlign newTextVAlign) {
        this.textVAlign = newTextVAlign;
    }

    public void setTextHAlign(HorizontalAlign newTextHAlign) {
        this.textHAlign = newTextHAlign;
    }

    public void setColor(Color newColor) {
        if (newColor != null) {
            this.color = newColor;
        }
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public String getWrappedText() {
        StringBuffer result = new StringBuffer();
        if (this.textLines.length > 0) {
            result.append(this.textLines[0]);
            for (int i = 1; i < this.textLines.length; ++i) {
                result.append('\n' + this.textLines[i]);
            }
        }
        return result.toString();
    }

    public void setTextLineHeight(SizeValue textLineHeight) {
        this.textLineHeight = textLineHeight;
    }

    public void setTextMinHeight(SizeValue textMinHeight) {
        this.textMinHeight = textMinHeight;
    }

    private String[] wrapText(int width, NiftyRenderEngine r, String[] textLines) {
        RenderFont font = this.ensureFont(r);
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : textLines) {
            int lineLengthInPixel = font.getWidth(line);
            if (lineLengthInPixel > width) {
                lines.addAll(new TextBreak(line, width, font).split());
                continue;
            }
            lines.add(line);
        }
        return lines.toArray(new String[0]);
    }

    public void setWidthConstraint(Element element, SizeValue elementConstraintWidth, int parentWidth, NiftyRenderEngine renderEngine) {
        if (elementConstraintWidth == null || parentWidth == 0 || !this.lineWrapping || this.isCalculatedLineWrapping) {
            return;
        }
        int valueAsInt = element.getWidth();
        if (valueAsInt == 0) {
            valueAsInt = elementConstraintWidth.getValueAsInt(parentWidth);
        }
        if (valueAsInt <= 0) {
            return;
        }
        this.textLines = this.wrapText(valueAsInt, renderEngine, this.originalText.split("\n", -1));
        this.maxWidth = valueAsInt;
        if (this.maxWidth == 0) {
            for (String line : this.textLines) {
                int lineWidth = this.font.getWidth(line);
                if (lineWidth <= this.maxWidth) continue;
                this.maxWidth = lineWidth;
            }
        }
        element.setConstraintWidth(new SizeValue(this.getTextWidth() + "px"));
        element.setConstraintHeight(new SizeValue(this.getTextHeight() + "px"));
        this.isCalculatedLineWrapping = true;
    }

    public void setLineWrapping(boolean lineWrapping) {
        this.lineWrapping = lineWrapping;
    }

    public boolean isLineWrapping() {
        return this.lineWrapping;
    }

    public VerticalAlign getTextVAlign() {
        return this.textVAlign;
    }

    public HorizontalAlign getTextHAlign() {
        return this.textHAlign;
    }

    public Color getColor() {
        return this.color;
    }

    public class RenderFontNull
    implements RenderFont {
        @Override
        public int getHeight() {
            return 0;
        }

        @Override
        public int getWidth(String text) {
            return 0;
        }

        public void render(String text, int x, int y, Color fontColor, float size) {
        }

        @Override
        public Integer getCharacterAdvance(char currentCharacter, char nextCharacter, float size) {
            return null;
        }

        @Override
        public void dispose() {
        }
    }
}

