/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyMethodInvoker;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.MouseClickMethods;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;

public class ElementInteractionClickHandler {
    private static final long REPEATED_CLICK_START_TIME = 100L;
    private static final long REPEATED_CLICK_TIME = 100L;
    private Nifty nifty;
    private Element element;
    private MouseClickMethods mouseMethods;
    private boolean isMouseDown;
    private boolean onClickRepeatEnabled;
    private long mouseDownTime;
    private long lastRepeatStartTime;
    private int lastMouseX;
    private int lastMouseY;

    public ElementInteractionClickHandler(Nifty nifty, Element element, MouseClickMethods mouseMethods) {
        this.nifty = nifty;
        this.element = element;
        this.mouseMethods = mouseMethods;
        this.setMouseDown(false, 0L);
    }

    public MouseClickMethods getMouseMethods() {
        return this.mouseMethods;
    }

    public void setOnClickRepeatEnabled(boolean onClickRepeatEnabled) {
        this.onClickRepeatEnabled = onClickRepeatEnabled;
    }

    public boolean isOnClickRepeatEnabled() {
        return this.onClickRepeatEnabled;
    }

    public boolean process(NiftyMouseInputEvent mouseEvent, boolean isButtonDown, boolean isInitialButtonDown, boolean isButtonRelease, long eventTime, boolean mouseInside, boolean canHandleInteraction, boolean hasMouseAccess, String onClickAlternateKey) {
        long pastTime;
        long repeatTime;
        long deltaTime;
        if (this.onClickRepeatEnabled && mouseInside && this.isMouseDown && isButtonDown && (deltaTime = eventTime - this.mouseDownTime) > 100L && (repeatTime = (pastTime = deltaTime - 100L) - this.lastRepeatStartTime) > 100L) {
            this.lastRepeatStartTime = pastTime;
            if (this.onClickMouse(this.element.getId(), mouseEvent, canHandleInteraction, onClickAlternateKey)) {
                return true;
            }
        }
        boolean processed = false;
        if (mouseInside && !this.isMouseDown) {
            if (isButtonDown && isInitialButtonDown) {
                this.setMouseDown(true, eventTime);
                this.onInitialClick();
                processed = this.onClickMouse(this.element.getId(), mouseEvent, canHandleInteraction, onClickAlternateKey) || processed;
            }
        } else if (!isButtonDown && this.isMouseDown) {
            this.setMouseDown(false, eventTime);
        }
        if (isButtonRelease && (mouseInside || hasMouseAccess)) {
            boolean bl = processed = this.onMouseRelease(mouseEvent) || processed;
        }
        if (this.isMouseDown) {
            processed = this.onClickMouseMove(mouseEvent) || processed;
        }
        return processed;
    }

    private void setMouseDown(boolean newMouseDown, long eventTime) {
        this.mouseDownTime = eventTime;
        this.lastRepeatStartTime = 0L;
        this.isMouseDown = newMouseDown;
    }

    public void resetMouseDown() {
        this.isMouseDown = false;
    }

    private void onInitialClick() {
        this.mouseMethods.onInitialClick();
    }

    private boolean onClickMouse(String elementId, NiftyMouseInputEvent inputEvent, boolean canHandleInteraction, String onClickAlternateKey) {
        if (canHandleInteraction) {
            this.lastMouseX = inputEvent.getMouseX();
            this.lastMouseY = inputEvent.getMouseY();
            return this.mouseMethods.onClick(this.nifty, onClickAlternateKey, inputEvent);
        }
        return false;
    }

    private boolean onClickMouseMove(NiftyMouseInputEvent inputEvent) {
        if (this.lastMouseX == inputEvent.getMouseX() && this.lastMouseY == inputEvent.getMouseY()) {
            return false;
        }
        this.lastMouseX = inputEvent.getMouseX();
        this.lastMouseY = inputEvent.getMouseY();
        return this.mouseMethods.onClickMouseMove(this.nifty, inputEvent);
    }

    private boolean onMouseRelease(NiftyMouseInputEvent mouseEvent) {
        return this.mouseMethods.onMouseRelease(this.nifty, mouseEvent);
    }

    public void activate(Nifty nifty) {
        this.mouseMethods.onActivate(nifty);
    }

    public void setOnClickMethod(NiftyMethodInvoker onClickMethod) {
        this.mouseMethods.setOnClickMethod(onClickMethod);
    }

    public void setOnClickMouseMoveMethod(NiftyMethodInvoker onClickMouseMoveMethod) {
        this.mouseMethods.setOnClickMouseMoveMethod(onClickMouseMoveMethod);
    }

    public void setOnReleaseMethod(NiftyMethodInvoker onReleaseMethod) {
        this.mouseMethods.setOnReleaseMethod(onReleaseMethod);
    }
}

