/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.image.ImageModeFactory;
import de.lessvoid.nifty.render.image.ImageModeHelper;
import de.lessvoid.nifty.tools.Alpha;
import de.lessvoid.nifty.tools.SizeValue;

public class ImageOverlay
implements EffectImpl {
    private NiftyImage image;
    private Alpha alpha;
    private SizeValue inset;
    private SizeValue width;
    private SizeValue height;
    private boolean center;
    private boolean hideIfNotEnoughSpace;
    private boolean activeBeforeStartDelay;

    @Override
    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.image = nifty.getRenderEngine().createImage(parameter.getProperty("filename"), false);
        String areaProviderProperty = new ImageModeHelper().getAreaProviderProperty(parameter);
        String renderStrategyProperty = new ImageModeHelper().getRenderStrategyProperty(parameter);
        if (areaProviderProperty != null || renderStrategyProperty != null) {
            this.image.setImageMode(ImageModeFactory.getSharedInstance().createImageMode(areaProviderProperty, renderStrategyProperty));
        }
        this.alpha = new Alpha(parameter.getProperty("alpha", "#f"));
        this.inset = new SizeValue(parameter.getProperty("inset", "0px"));
        this.width = new SizeValue(parameter.getProperty("width", element.getWidth() + "px"));
        this.height = new SizeValue(parameter.getProperty("height", element.getHeight() + "px"));
        this.center = Boolean.valueOf(parameter.getProperty("center", "false"));
        this.hideIfNotEnoughSpace = Boolean.valueOf(parameter.getProperty("hideIfNotEnoughSpace", "false"));
        this.activeBeforeStartDelay = Boolean.valueOf(parameter.getProperty("activeBeforeStartDelay", "false"));
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        if (!this.activeBeforeStartDelay && (double)normalizedTime <= 0.0) {
            return;
        }
        int insetOffset = this.inset.getValueAsInt(element.getWidth());
        int imageX = element.getX() + insetOffset;
        int imageY = element.getY() + insetOffset;
        int imageWidth = this.width.getValueAsInt(element.getWidth()) - insetOffset * 2;
        int imageHeight = this.height.getValueAsInt(element.getHeight()) - insetOffset * 2;
        if (this.hideIfNotEnoughSpace && (imageWidth > element.getWidth() || imageHeight > element.getHeight())) {
            return;
        }
        r.saveState(null);
        if (falloff != null) {
            r.setColorAlpha(this.alpha.mutiply(falloff.getFalloffValue()).getAlpha());
        } else if (!r.isColorAlphaChanged()) {
            r.setColorAlpha(this.alpha.getAlpha());
        }
        if (this.center) {
            r.renderImage(this.image, element.getX() + (element.getWidth() - imageWidth) / 2, element.getY() + (element.getHeight() - imageHeight) / 2, imageWidth, imageHeight);
        } else {
            r.renderImage(this.image, imageX, imageY, imageWidth, imageHeight);
        }
        r.restoreState();
    }

    @Override
    public void deactivate() {
        this.image.dispose();
    }
}

