/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dynamic.attributes;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.StandardControl;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectOnHoverAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectsAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlInteractAttributes;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.loaderv2.types.AttributesType;
import de.lessvoid.nifty.loaderv2.types.ControlType;
import de.lessvoid.nifty.loaderv2.types.EffectsType;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.loaderv2.types.ImageType;
import de.lessvoid.nifty.loaderv2.types.LayerType;
import de.lessvoid.nifty.loaderv2.types.PanelType;
import de.lessvoid.nifty.loaderv2.types.PopupType;
import de.lessvoid.nifty.loaderv2.types.StyleType;
import de.lessvoid.nifty.loaderv2.types.TextType;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;

public class ControlAttributes {
    protected Attributes attributes = new Attributes();
    protected ControlInteractAttributes interact;
    protected ControlEffectsAttributes effects;
    private boolean isAutoId = false;

    public void setInteract(ControlInteractAttributes controlInteract) {
        this.interact = controlInteract;
    }

    public void setEffects(ControlEffectsAttributes controlEffects) {
        this.effects = controlEffects;
    }

    public void set(String key, String value) {
        this.attributes.set(key, value);
    }

    public String get(String key) {
        return this.attributes.get(key);
    }

    public void setId(String id) {
        this.isAutoId = false;
        this.attributes.set("id", id);
    }

    public void setAutoId(String id) {
        this.isAutoId = true;
        this.attributes.set("id", id);
    }

    public boolean isAutoId() {
        return this.isAutoId;
    }

    public void setName(String name) {
        this.attributes.set("name", name);
    }

    public void setHeight(String height) {
        this.attributes.set("height", height);
    }

    public void setWidth(String width) {
        this.attributes.set("width", width);
    }

    public void setX(String x) {
        this.attributes.set("x", x);
    }

    public void setY(String y) {
        this.attributes.set("y", y);
    }

    public void setAlign(String align) {
        this.attributes.set("align", align);
    }

    public void setVAlign(String valign) {
        this.attributes.set("valign", valign);
    }

    public void setPadding(String padding) {
        this.attributes.set("padding", padding);
    }

    public void setPaddingLeft(String paddingLeft) {
        this.attributes.set("paddingLeft", paddingLeft);
    }

    public void setPaddingRight(String paddingRight) {
        this.attributes.set("paddingRight", paddingRight);
    }

    public void setPaddingTop(String paddingTop) {
        this.attributes.set("paddingTop", paddingTop);
    }

    public void setPaddingBottom(String paddingBottom) {
        this.attributes.set("paddingBottom", paddingBottom);
    }

    public void setChildClip(String childClip) {
        this.attributes.set("childClip", childClip);
    }

    public void setVisible(String visible) {
        this.attributes.set("visible", visible);
    }

    public void setVisibleToMouse(String visibleToMouse) {
        this.attributes.set("visibleToMouse", visibleToMouse);
    }

    public void setChildLayout(String childLayout) {
        this.attributes.set("childLayout", childLayout);
    }

    public void setFocusable(String focusable) {
        this.attributes.set("focusable", focusable);
    }

    public void setFocusableInsertBeforeElementId(String focusableInsertBeforeElementId) {
        this.attributes.set("focusableInsertBeforeElementId", focusableInsertBeforeElementId);
    }

    public void setFont(String font) {
        this.attributes.set("font", font);
    }

    public void setTextHAlign(String textHAlign) {
        this.attributes.set("textHAlign", textHAlign);
    }

    public void setTextVAlign(String textVAlign) {
        this.attributes.set("textVAlign", textVAlign);
    }

    public void setColor(String color) {
        this.attributes.set("color", color);
    }

    public void setSelectionColor(String selectionColor) {
        this.attributes.set("selectionColor", selectionColor);
    }

    public void setText(String text) {
        this.attributes.set("text", text);
    }

    public void setBackgroundColor(String backgroundColor) {
        this.attributes.set("backgroundColor", backgroundColor);
    }

    public void setBackgroundImage(String backgroundImage) {
        this.attributes.set("backgroundImage", backgroundImage);
    }

    public void setImageMode(String imageMode) {
        this.attributes.set("imageMode", imageMode);
    }

    public void setFilename(String filename) {
        this.attributes.set("filename", filename);
    }

    public void setInset(String inset) {
        this.attributes.set("inset", inset);
    }

    public void setController(String controller) {
        this.attributes.set("controller", controller);
    }

    public void setInputMapping(String inputMapping) {
        this.attributes.set("inputMapping", inputMapping);
    }

    public void setStyle(String style) {
        this.attributes.set("style", style);
    }

    public void setInteractAttribute(String name, String value) {
        this.ensureInteract();
        this.interact.setAttribute(name, value);
    }

    public void setInteractOnClick(String onClick) {
        this.ensureInteract();
        this.interact.setOnClick(onClick);
    }

    public void setInteractOnRelease(String onRelease) {
        this.ensureInteract();
        this.interact.setOnRelease(onRelease);
    }

    public void setInteractOnMouseOver(String onMouseOver) {
        this.ensureInteract();
        this.interact.setOnMouseOver(onMouseOver);
    }

    public void setInteractOnClickRepeat(String onClickRepeat) {
        this.ensureInteract();
        this.interact.setOnClickRepeat(onClickRepeat);
    }

    public void setInteractOnClickMouseMove(String onClickMouseMove) {
        this.ensureInteract();
        this.interact.setOnClickMouseMove(onClickMouseMove);
    }

    public void setInteractOnClickAlternateKey(String onClickAlternateKey) {
        this.ensureInteract();
        this.interact.setOnClickAlternateKey(onClickAlternateKey);
    }

    private void ensureInteract() {
        if (this.interact == null) {
            this.interact = new ControlInteractAttributes();
        }
    }

    public void setEffectsAttribute(String name, String value) {
        this.ensureEffects();
        this.effects.setAttribute(name, value);
    }

    public void setEffectsOverlay(String overlay) {
        this.ensureEffects();
        this.effects.setOverlay(overlay);
    }

    public void addEffectsOnStartScreen(ControlEffectAttributes effectParam) {
        this.ensureEffects();
        this.effects.addOnStartScreen(effectParam);
    }

    public void addEffectsOnEndScreen(ControlEffectAttributes effectParam) {
        this.ensureEffects();
        this.effects.addOnEndScreen(effectParam);
    }

    public void addEffectsOnHover(ControlEffectOnHoverAttributes effectParam) {
        this.ensureEffects();
        this.effects.addOnHover(effectParam);
    }

    public void addEffectsOnStartHover(ControlEffectOnHoverAttributes effectParam) {
        this.ensureEffects();
        this.effects.addOnStartHover(effectParam);
    }

    public void addEffectsOnEndHover(ControlEffectOnHoverAttributes effectParam) {
        this.ensureEffects();
        this.effects.addOnEndHover(effectParam);
    }

    public void addEffectsOnClick(ControlEffectAttributes effectParam) {
        this.ensureEffects();
        this.effects.addOnClick(effectParam);
    }

    public void addEffectsOnFocus(ControlEffectAttributes effectParam) {
        this.ensureEffects();
        this.effects.addOnFocus(effectParam);
    }

    public void addEffectsOnLostFocus(ControlEffectAttributes effectParam) {
        this.ensureEffects();
        this.effects.addOnLostFocus(effectParam);
    }

    public void addEffectsOnGetFocus(ControlEffectAttributes effectParam) {
        this.ensureEffects();
        this.effects.addOnGetFocus(effectParam);
    }

    public void addEffectsOnActive(ControlEffectAttributes effectParam) {
        this.ensureEffects();
        this.effects.addOnActive(effectParam);
    }

    public void addEffectsOnShow(ControlEffectAttributes effectParam) {
        this.ensureEffects();
        this.effects.addOnShow(effectParam);
    }

    public void addEffectsOnHide(ControlEffectAttributes effectParam) {
        this.ensureEffects();
        this.effects.addOnHide(effectParam);
    }

    public void addEffectsOnCustom(ControlEffectAttributes effectParam) {
        this.ensureEffects();
        this.effects.addOnCustom(effectParam);
    }

    private void ensureEffects() {
        if (this.effects == null) {
            this.effects = new ControlEffectsAttributes();
        }
    }

    protected Element createControlInternal(Nifty nifty, Screen screen, Element parent) {
        ControlType controlType = new ControlType(this.attributes);
        return this.buildControl(nifty, screen, parent, controlType, new LayoutPart());
    }

    protected Element createText(Nifty nifty, Screen screen, Element parent) {
        TextType textType = new TextType(this.attributes);
        return this.buildControl(nifty, screen, parent, textType, new LayoutPart());
    }

    protected Element createPanel(Nifty nifty, Screen screen, Element parent) {
        PanelType panelType = new PanelType(this.attributes);
        return this.buildControl(nifty, screen, parent, panelType, new LayoutPart());
    }

    protected void registerPopup(Nifty nifty) {
        PopupType popupType = new PopupType(this.attributes);
        popupType.translateSpecialValues(nifty, null);
        nifty.registerPopup(popupType);
    }

    protected Element createLayer(Nifty nifty, Screen screen, Element parent) {
        LayerType layerType = new LayerType(this.attributes);
        return this.buildControl(nifty, screen, parent, layerType, nifty.getRootLayerFactory().createRootLayerLayoutPart(nifty));
    }

    protected Element createImage(Nifty nifty, Screen screen, Element parent) {
        ImageType imageType = new ImageType(this.attributes);
        return this.buildControl(nifty, screen, parent, imageType, new LayoutPart());
    }

    private Element buildControl(Nifty nifty, Screen screen, Element parent, ElementType elementType, LayoutPart layoutPart) {
        if (this.effects != null) {
            elementType.setEffect(this.effects.create());
        }
        if (this.interact != null) {
            elementType.setInteract(this.interact.create());
        }
        elementType.prepare(nifty, screen, parent.getElementType());
        elementType.connectParentControls(parent);
        Element element = elementType.create(parent, nifty, screen, layoutPart);
        parent.layoutElements();
        screen.layoutLayers();
        return element;
    }

    protected StandardControl getStandardControl() {
        return new StandardControl(){

            @Override
            public Element createControl(Nifty nifty, Screen screen, Element parent) throws Exception {
                return ControlAttributes.this.createControlInternal(nifty, screen, parent);
            }
        };
    }

    public void refreshAttributes(Attributes attrib) {
        attrib.refreshFromAttributes(this.attributes);
    }

    public void refreshEffects(EffectsType effects) {
        if (this.effects != null) {
            effects.refreshFromAttributes(this.effects);
        }
    }

    public ElementType createType() {
        return null;
    }

    public void connect(ElementType e) {
        if (this.effects != null) {
            e.setEffect(this.effects.create());
        }
        if (this.interact != null) {
            e.setInteract(this.interact.create());
        }
    }

    public StyleType createStyleType(Attributes styleAttributes) {
        StyleType styleType = new StyleType(styleAttributes);
        if (this.attributes != null) {
            styleType.setAttributes(new AttributesType(this.attributes));
        }
        if (this.effects != null) {
            styleType.setEffect(this.effects.create());
        }
        if (this.interact != null) {
            styleType.setInteract(this.interact.create());
        }
        return styleType;
    }
}

