/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.os.Platform;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class VersionUtil {
    public static final String SEPERATOR = "-----------------------------------------------------------------------------------------------------";

    public static StringBuffer getPlatformInfo(StringBuffer sb) {
        if (null == sb) {
            sb = new StringBuffer();
        }
        sb.append(SEPERATOR).append(Platform.getNewline());
        sb.append("Platform: ").append(Platform.getOS()).append(' ').append(Platform.getOSVersion()).append(" (os), ");
        sb.append(Platform.getArch()).append(" (arch) ").append(Runtime.getRuntime().availableProcessors()).append(" cores");
        sb.append(Platform.getNewline());
        sb.append("Platform: littleEndian ").append(Platform.isLittleEndian()).append(", 32Bit ");
        sb.append(Platform.is32Bit()).append(", a-ptr bit-size ").append(Platform.getPointerSizeInBits());
        sb.append(Platform.getNewline());
        sb.append("Platform: Java ").append(Platform.getJavaVersion()).append(", ").append(System.getProperty("java.vm.name")).append(", ");
        sb.append(Platform.getJavaVendor()).append(", ").append(Platform.getJavaVendorURL()).append(", is JavaSE: ").append(Platform.isJavaSE());
        sb.append(Platform.getNewline()).append(SEPERATOR);
        return sb;
    }

    public static String getPlatformInfo() {
        return VersionUtil.getPlatformInfo(null).toString();
    }

    public static Manifest getManifest(ClassLoader cl, String extension) {
        try {
            Enumeration<URL> resources = cl.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                Attributes attributes = manifest.getMainAttributes();
                if (attributes == null || !extension.equals(attributes.getValue(Attributes.Name.EXTENSION_NAME))) continue;
                return manifest;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to read manifest.", ex);
        }
        return null;
    }

    public static StringBuffer getFullManifestInfo(Manifest mf, StringBuffer sb) {
        if (null == mf) {
            return sb;
        }
        if (null == sb) {
            sb = new StringBuffer();
        }
        Attributes attr = mf.getMainAttributes();
        Set<Object> keys = attr.keySet();
        for (Attributes.Name name : keys) {
            String val = attr.getValue(name);
            sb.append(" ");
            sb.append(name);
            sb.append(" = ");
            sb.append(val);
            sb.append(Platform.getNewline());
        }
        return sb;
    }
}

