/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.AbstractLongBuffer;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.Int64BufferME_CDC_FP;
import com.jogamp.common.nio.Int64BufferSE;
import com.jogamp.common.os.Platform;
import java.nio.ByteBuffer;

public abstract class Int64Buffer
extends AbstractLongBuffer {
    protected Int64Buffer(ByteBuffer bb) {
        super(bb, Int64Buffer.elementSize());
    }

    public static Int64Buffer allocate(int size) {
        if (Platform.isJavaSE()) {
            return new Int64BufferSE(ByteBuffer.wrap(new byte[Int64Buffer.elementSize() * size]));
        }
        return new Int64BufferME_CDC_FP(ByteBuffer.wrap(new byte[Int64Buffer.elementSize() * size]));
    }

    public static Int64Buffer allocateDirect(int size) {
        if (Platform.isJavaSE()) {
            return new Int64BufferSE(Buffers.newDirectByteBuffer(Int64Buffer.elementSize() * size));
        }
        return new Int64BufferME_CDC_FP(Buffers.newDirectByteBuffer(Int64Buffer.elementSize() * size));
    }

    public static Int64Buffer wrap(ByteBuffer src) {
        Int64Buffer res = Platform.isJavaSE() ? new Int64BufferSE(src) : new Int64BufferME_CDC_FP(src);
        res.updateBackup();
        return res;
    }

    public static int elementSize() {
        return 8;
    }

    @Override
    public String toString() {
        return "Int64Buffer:" + super.toString();
    }
}

