/*
 * Decompiled with CFR 0.152.
 */
package tgaimageplugin;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import tgaimageplugin.TGAHeader;
import tgaimageplugin.TGAImageReader;

public class TGAImageReaderSpi
extends ImageReaderSpi {
    public TGAImageReaderSpi() {
        super("pgi", "0.1", new String[]{"tga"}, new String[]{"tga", "TGA"}, new String[]{"image/x-tga"}, "tgaimageplugin.TGAImageReader", STANDARD_INPUT_TYPE, null, false, null, null, null, null, false, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDecodeInput(Object source) throws IOException {
        System.out.println("can decode input?");
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream in = (ImageInputStream)source;
        if (in.length() < 18L) {
            return false;
        }
        in.mark();
        ByteOrder oldOrder = in.getByteOrder();
        try {
            in.seek(1L);
            if (in.readUnsignedByte() > 1) {
                boolean bl = false;
                return bl;
            }
            if (in.readUnsignedByte() > 11) {
                boolean bl = false;
                return bl;
            }
            TGAHeader header = TGAHeader.create(in);
            if (header.getColorMapType() == TGAHeader.ColorMapType.NO_COLOR_MAP && header.getImageType() == TGAHeader.ImageType.UNCOMPRESSED_TRUE_COLOR) {
                boolean bl = header.getPixelDepth() == 24 || header.getPixelDepth() == 32;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            in.reset();
            in.setByteOrder(oldOrder);
        }
    }

    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new TGAImageReader(this);
    }

    public String getDescription(Locale locale) {
        return "TGA Image Reader";
    }
}

