/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.test;

import com.jme3.animation.AnimControl;
import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.BlenderKey;
import com.jme3.asset.ModelKey;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderLoader;
import com.jme3.scene.plugins.blender.BlenderModelLoader;
import com.jme3.scene.plugins.blender.test.config.ConfigDialog;
import com.jme3.scene.plugins.blender.test.config.IConfigExecutable;
import com.jme3.scene.plugins.blender.test.scene.Pivot;
import com.jme3.texture.plugins.AWTLoader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ManualBlenderTester
extends SimpleApplication {
    private static final Logger LOGGER = Logger.getLogger(ManualBlenderTester.class.getName());
    private ModelKey modelKey;

    public static void main(String[] args) {
        new ConfigDialog("./TestAssets", new IConfigExecutable(){

            public void execute(ModelKey modelKey, Level logLevel) {
                new ManualBlenderTester(modelKey, logLevel).start();
            }
        });
    }

    public ManualBlenderTester(ModelKey modelKey, Level logLevel) {
        Logger.getLogger("com.jme3").setLevel(logLevel);
        this.modelKey = modelKey;
        this.showSettings = false;
    }

    public void simpleInitApp() {
        this.assetManager.registerLocator(".", FileLocator.class);
        this.assetManager.registerLoader(BlenderLoader.class, new String[]{"blend"});
        this.assetManager.registerLoader(AWTLoader.class, new String[]{"png"});
        this.viewPort.setBackgroundColor(ColorRGBA.Gray);
        this.flyCam.setMoveSpeed(20.0f);
        this.cam.setFrustumFar(1000.0f);
        this.cam.setFrustumNear(1.0f);
        AssetInfo ai = new AssetInfo(this.assetManager, (AssetKey)this.modelKey){

            public InputStream openStream() {
                try {
                    return new FileInputStream(this.key.getName());
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    return null;
                }
            }
        };
        this.rootNode.attachChild((Spatial)new Pivot(this.assetManager));
        if (this.modelKey instanceof BlenderKey) {
            Map.Entry<String, Map<String, int[]>> animEntry;
            Iterator<Map.Entry<String, int[]>> i$;
            Iterator<Map.Entry<String, Map<String, int[]>>> i$2;
            Node blenderModel = this.testBlenderLoader(ai);
            Map<String, Map<String, int[]>> animations = ((BlenderKey)this.modelKey).getAnimations();
            if (((BlenderKey)this.modelKey).getAnimations() != null && (i$2 = animations.entrySet().iterator()).hasNext() && (i$ = (animEntry = i$2.next()).getValue().entrySet().iterator()).hasNext()) {
                Map.Entry<String, int[]> anim = i$.next();
                Spatial animatedSpatial = this.findNode(blenderModel, animEntry.getKey());
                ((AnimControl)animatedSpatial.getControl(AnimControl.class)).createChannel().setAnim(anim.getKey());
            }
        } else {
            this.testBlenderModelLoader(ai);
        }
        DirectionalLight sun = new DirectionalLight();
        sun.setDirection(new Vector3f(0.0f, -10.0f, 0.0f).normalizeLocal());
        sun.setColor(ColorRGBA.White);
        this.rootNode.addLight((Light)sun);
    }

    private Spatial findNode(Node rootNode, String name) {
        if (name.equals(rootNode.getName())) {
            return rootNode;
        }
        return rootNode.getChild(name);
    }

    private Node testBlenderLoader(AssetInfo assetInfo) {
        Node blenderModel = null;
        BlenderLoader blenderLoader = new BlenderLoader();
        try {
            BlenderKey.LoadingResults loadingResults = blenderLoader.load(assetInfo);
            for (Node object : loadingResults.getObjects()) {
                this.rootNode.attachChild((Spatial)object);
                blenderModel = object;
            }
            for (Light light : loadingResults.getLights()) {
                this.rootNode.addLight(light);
            }
            for (Camera camera : loadingResults.getCameras()) {
                LOGGER.info(camera.toString());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return blenderModel;
    }

    private Node testBlenderModelLoader(AssetInfo assetInfo) {
        BlenderModelLoader blenderLoader = new BlenderModelLoader();
        try {
            Spatial loadingResults = blenderLoader.load(assetInfo);
            this.rootNode.attachChild(loadingResults);
            if (loadingResults instanceof Node) {
                return (Node)loadingResults;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }
}

